/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import org.irods.jargon.core.exception.JargonException;

public final class IRODSGenQuery {
    private final String queryString;
    private final int numberOfResultsDesired;

    public static IRODSGenQuery instance(String queryString, int numberOfResultsDesired) throws JargonException {
        return new IRODSGenQuery(queryString, numberOfResultsDesired, RowCountOptions.NO_ROW_COUNT, 0);
    }

    public static IRODSGenQuery instance(String queryString, int numberOfResultsDesired, RowCountOptions rowCountOption) throws JargonException {
        return new IRODSGenQuery(queryString, numberOfResultsDesired, rowCountOption, 0);
    }

    private IRODSGenQuery(String queryString, int numberOfResultsDesired, RowCountOptions rowCountOption, int skip) throws JargonException {
        if (queryString == null || queryString.length() == 0) {
            throw new JargonException("query string must be supplied");
        }
        if (numberOfResultsDesired <= 0) {
            throw new JargonException("number of results desired must be greater than zero");
        }
        if (rowCountOption == null) {
            throw new JargonException("row count option cannot be null");
        }
        if (skip < 0) {
            throw new JargonException("skip value cannot be negative");
        }
        this.queryString = queryString;
        this.numberOfResultsDesired = numberOfResultsDesired;
    }

    private IRODSGenQuery(String queryString, int numberOfResultsDesired) throws JargonException {
        this(queryString, numberOfResultsDesired, RowCountOptions.NO_ROW_COUNT, 0);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int getNumberOfResultsDesired() {
        return this.numberOfResultsDesired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IRODSQuery:");
        sb.append("\n   queryString:");
        sb.append(this.queryString);
        sb.append("\n    numberOfResultsDesired:");
        sb.append(this.numberOfResultsDesired);
        return sb.toString();
    }

    public static enum RowCountOptions {
        NO_ROW_COUNT,
        ROW_COUNT_FOR_THIS_RESULT,
        ROW_COUNT_INCLUDING_SKIPPED_ROWS;

    }
}

