/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.domain.IRODSDomainObject;

public final class MetaDataAndDomainData
extends IRODSDomainObject {
    private final MetadataDomain metadataDomain;
    private final String domainObjectId;
    private final String domainObjectUniqueName;
    private final String avuAttribute;
    private final String avuValue;
    private final String avuUnit;

    public static MetaDataAndDomainData instance(MetadataDomain metadataDomain, String domainObjectId, String domainObjectUniqueName, String avuAttribute, String avuValue, String avuUnit) throws JargonException {
        return new MetaDataAndDomainData(metadataDomain, domainObjectId, domainObjectUniqueName, avuAttribute, avuValue, avuUnit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaDataAndDomainData:");
        sb.append("\n   domain:");
        sb.append((Object)this.metadataDomain);
        sb.append("\n   id:");
        sb.append(this.domainObjectId);
        sb.append("\n   domainObjectUniqueName:");
        sb.append(this.domainObjectUniqueName);
        sb.append("\n   avuAttribute:");
        sb.append(this.avuAttribute);
        sb.append("\n   avuValue:");
        sb.append(this.avuValue);
        sb.append("\n   avuUnit:");
        sb.append(this.avuUnit);
        return sb.toString();
    }

    private MetaDataAndDomainData(MetadataDomain metadataDomain, String domainObjectId, String domainObjectUniqueName, String avuAttribute, String avuValue, String avuUnit) throws JargonException {
        if (metadataDomain == null) {
            throw new JargonException("metadataDomain is null");
        }
        if (domainObjectId == null || domainObjectId.isEmpty()) {
            throw new JargonException("domain object id is null or empty");
        }
        if (domainObjectUniqueName == null || domainObjectUniqueName.isEmpty()) {
            throw new JargonException("domain object unique name is null or empty");
        }
        if (avuAttribute == null || avuAttribute.isEmpty()) {
            throw new JargonException("avu attribute is null or empty");
        }
        if (avuValue == null) {
            throw new JargonException("avu value is null");
        }
        if (avuUnit == null) {
            throw new JargonException("avu unit is null");
        }
        this.metadataDomain = metadataDomain;
        this.domainObjectId = domainObjectId;
        this.domainObjectUniqueName = domainObjectUniqueName;
        this.avuAttribute = avuAttribute;
        this.avuValue = avuValue;
        this.avuUnit = avuUnit;
    }

    public String getDomainObjectId() {
        return this.domainObjectId;
    }

    public String getDomainObjectUniqueName() {
        return this.domainObjectUniqueName;
    }

    public String getAvuAttribute() {
        return this.avuAttribute;
    }

    public String getAvuValue() {
        return this.avuValue;
    }

    public String getAvuUnit() {
        return this.avuUnit;
    }

    public MetadataDomain getMetadataDomain() {
        return this.metadataDomain;
    }

    public static enum MetadataDomain {
        RESOURCE,
        USER,
        DATA,
        COLLECTION;

    }
}

