/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.remoteexecute;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.irods.jargon.core.connection.IRODSCommands;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ExecCmd;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.io.RemoteExecutionBinaryResultInputStream;
import org.irods.jargon.core.remoteexecute.RemoteExecutionService;
import org.irods.jargon.core.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecuteServiceImpl
implements RemoteExecutionService {
    private final IRODSCommands irodsCommands;
    private final String commandToExecuteWithoutArguments;
    private final String argumentsToPassWithCommand;
    private final String executionHost;
    private final String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
    public static final String STREAMING_API_CUTOFF = "rods2.4.1";
    private ExecCmd.PathHandlingMode pathHandlingMode = ExecCmd.PathHandlingMode.NONE;
    private static final Logger log = LoggerFactory.getLogger(RemoteExecuteServiceImpl.class);
    private static final String STATUS = "status";

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RemoteExecuteServiceImpl");
        sb.append("\n  commandToExecuteWithoutArguments:");
        sb.append(this.commandToExecuteWithoutArguments);
        sb.append("\n   argumentsToPassWithCommand:");
        sb.append(this.argumentsToPassWithCommand);
        sb.append("\n   executionHost:");
        sb.append(this.executionHost);
        sb.append("\n   absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn:");
        sb.append(this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn);
        sb.append("\n   pathHandlingMode:");
        sb.append((Object)this.pathHandlingMode);
        sb.append("\n   irodsCommands:");
        sb.append(this.irodsCommands);
        return sb.toString();
    }

    public static final RemoteExecutionService instance(IRODSCommands irodsCommands, String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost) throws JargonException {
        return new RemoteExecuteServiceImpl(irodsCommands, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, "", ExecCmd.PathHandlingMode.NONE);
    }

    public static final RemoteExecutionService instanceWhenUsingAbsPathToSetCommandArg(IRODSCommands irodsCommands, String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn) throws JargonException {
        return new RemoteExecuteServiceImpl(irodsCommands, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, ExecCmd.PathHandlingMode.USE_PATH_TO_ADD_PHYS_PATH_ARGUMENT_TO_REMOTE_SCRIPT);
    }

    public static final RemoteExecutionService instanceWhenUsingAbsPathToFindExecutionHost(IRODSCommands irodsCommands, String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn) throws JargonException {
        return new RemoteExecuteServiceImpl(irodsCommands, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, ExecCmd.PathHandlingMode.USE_PATH_TO_FIND_EXECUTING_HOST);
    }

    private RemoteExecuteServiceImpl(IRODSCommands irodsCommands, String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, ExecCmd.PathHandlingMode pathHandlingMode) throws JargonException {
        if (irodsCommands == null) {
            throw new JargonException("null irodsCommands");
        }
        if (commandToExecuteWithoutArguments == null || commandToExecuteWithoutArguments.length() == 0) {
            throw new JargonException("null commandToExecuteWithoutArguments");
        }
        if (argumentsToPassWithCommand == null) {
            throw new JargonException("null argumentsToPassWithCommand, set to blank if not used");
        }
        if (executionHost == null) {
            throw new JargonException("null executionHost, set to blank if not used");
        }
        if (absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn == null) {
            throw new JargonException("null absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, set to blank if not used");
        }
        if (pathHandlingMode == null) {
            throw new IllegalArgumentException("null pathHandlingMode");
        }
        this.irodsCommands = irodsCommands;
        this.commandToExecuteWithoutArguments = commandToExecuteWithoutArguments;
        this.argumentsToPassWithCommand = argumentsToPassWithCommand;
        this.executionHost = executionHost;
        this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn = absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
        this.pathHandlingMode = pathHandlingMode;
    }

    @Override
    public InputStream execute() throws JargonException {
        Tag message;
        log.info("executing a remote command:{}", (Object)this.toString());
        ExecCmd execCmd = null;
        execCmd = this.getIrodsCommands().getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion(STREAMING_API_CUTOFF) ? ExecCmd.instanceWithHostAndArgumentsToPassParametersPost25(this.commandToExecuteWithoutArguments, this.argumentsToPassWithCommand, this.executionHost, this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, this.pathHandlingMode) : ExecCmd.instanceWithHostAndArgumentsToPassParametersPriorTo25(this.commandToExecuteWithoutArguments, this.argumentsToPassWithCommand, this.executionHost, this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, this.pathHandlingMode);
        StringBuilder buffer = new StringBuilder();
        try {
            message = this.irodsCommands.irodsFunction(execCmd);
        }
        catch (NullPointerException e) {
            log.error("NullPointerException encountered executing a command", e);
            throw new JargonException("NullPointerException executing a command, which can occur if the command output is too long");
        }
        if (message == null) {
            throw new JargonException("null response from remote execution");
        }
        int length = message.getTag("BinBytesBuf_PI", 0).getTag("buflen").getIntValue();
        if (length > 0) {
            buffer.append(message.getTag("BinBytesBuf_PI", 0).getTag("buf").getStringValue());
        }
        if ((length = message.getTag("BinBytesBuf_PI", 1).getTag("buflen").getIntValue()) > 0) {
            buffer.append(message.getTag("BinBytesBuf_PI", 1).getTag("buf").getStringValue());
        }
        return new ByteArrayInputStream(Base64.fromString(buffer.toString()));
    }

    @Override
    public InputStream executeAndStream() throws JargonException {
        Tag message;
        log.info("executing a remote command with streaming:{}", (Object)this.toString());
        if (!this.getIrodsCommands().getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion(STREAMING_API_CUTOFF)) {
            log.error("cannot stream remote commands, unsupported on this iRODS version:{}", this.getIrodsCommands().getIRODSServerProperties());
            throw new JargonException("cannot stream remote commands, unsupported on this iRODS version");
        }
        ExecCmd execCmd = ExecCmd.instanceWithHostAndArgumentsToPassParametersAllowingStreamingForLargeResultsPost25(this.commandToExecuteWithoutArguments, this.argumentsToPassWithCommand, this.executionHost, this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, this.pathHandlingMode);
        StringBuilder buffer = new StringBuilder();
        try {
            message = this.irodsCommands.irodsFunction(execCmd);
        }
        catch (NullPointerException e) {
            log.error("NullPointerException encountered executing a command", e);
            throw new JargonException("NullPointerException executing a command, which can occur if the command output is too long");
        }
        if (message == null) {
            throw new JargonException("null response from remote execution");
        }
        int length = message.getTag("BinBytesBuf_PI", 0).getTag("buflen").getIntValue();
        if (length > 0) {
            buffer.append(message.getTag("BinBytesBuf_PI", 0).getTag("buf").getStringValue());
        }
        if ((length = message.getTag("BinBytesBuf_PI", 1).getTag("buflen").getIntValue()) > 0) {
            buffer.append(message.getTag("BinBytesBuf_PI", 1).getTag("buf").getStringValue());
        }
        return this.buildAppropriateResultStream(message, buffer);
    }

    private InputStream buildAppropriateResultStream(Tag message, StringBuilder buffer) {
        InputStream resultStream;
        int status = message.getTag(STATUS).getIntValue();
        log.debug("status from remoteexec response:{}", status);
        if (status > 0) {
            log.info("additional data will be streamed, opening up will create concatenated stream");
            ByteArrayInputStream piData = new ByteArrayInputStream(Base64.fromString(buffer.toString()));
            RemoteExecutionBinaryResultInputStream reStream = new RemoteExecutionBinaryResultInputStream(this.getIrodsCommands(), status);
            resultStream = new SequenceInputStream(piData, reStream);
        } else {
            log.info("no additional data to stream, will return simple stream from result buffer");
            resultStream = new ByteArrayInputStream(Base64.fromString(buffer.toString()));
        }
        return resultStream;
    }

    public IRODSCommands getIrodsCommands() {
        return this.irodsCommands;
    }

    public String getCommandToExecuteWithoutArguments() {
        return this.commandToExecuteWithoutArguments;
    }

    public String getArgumentsToPassWithCommand() {
        return this.argumentsToPassWithCommand;
    }

    public String getExecutionHost() {
        return this.executionHost;
    }

    public String getAbsolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn() {
        return this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
    }
}

