/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.rule.IRODSRule;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.irods.jargon.core.rule.JargonRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSRuleTranslator {
    private static final String SPLAT = "*";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final IRODSServerProperties irodsServerProperties;

    public IRODSRuleTranslator(IRODSServerProperties irodsServerProperties) {
        if (irodsServerProperties == null) {
            throw new IllegalArgumentException("null irodsServerProperties");
        }
        this.irodsServerProperties = irodsServerProperties;
    }

    public IRODSRule translatePlainTextRuleIntoIRODSRule(String ruleAsPlainText) throws JargonRuleException, JargonException {
        if (ruleAsPlainText == null || ruleAsPlainText.isEmpty()) {
            throw new IllegalArgumentException("null or empty rule text");
        }
        this.log.info("translating rule: {}", (Object)ruleAsPlainText);
        StringTokenizer tokens = new StringTokenizer(ruleAsPlainText, "\n");
        ArrayList<String> tokenLines = new ArrayList<String>();
        while (tokens.hasMoreElements()) {
            tokenLines.add(tokens.nextToken());
        }
        String ruleBody = IRODSRuleTranslator.processRuleBody(tokenLines);
        if (tokenLines.size() < 3) {
            this.log.error("unable to find the required lines (rule body, input parameters, output parameters) in rule body:{}", (Object)ruleAsPlainText);
            throw new JargonRuleException("Rule requires at least 3 lines for body, input, and output parameters");
        }
        List<IRODSRuleParameter> inputParameters = this.processRuleInputAttributesLine((String)tokenLines.get(tokenLines.size() - 2));
        List<IRODSRuleParameter> outputParameters = this.processRuleOutputAttributesLine((String)tokenLines.get(tokenLines.size() - 1));
        IRODSRule irodsRule = IRODSRule.instance(ruleAsPlainText, inputParameters, outputParameters, ruleBody);
        return irodsRule;
    }

    public IRODSRule translatePlainTextRuleIntoIRODSRule(String ruleAsPlainText, List<IRODSRuleParameter> overrideInputParameters) throws JargonRuleException, JargonException {
        if (ruleAsPlainText == null || ruleAsPlainText.isEmpty()) {
            throw new IllegalArgumentException("null or empty rule text");
        }
        this.log.info("translating rule: {}", (Object)ruleAsPlainText);
        StringTokenizer tokens = new StringTokenizer(ruleAsPlainText, "\n");
        ArrayList<String> tokenLines = new ArrayList<String>();
        while (tokens.hasMoreElements()) {
            tokenLines.add(tokens.nextToken());
        }
        String ruleBody = IRODSRuleTranslator.processRuleBody(tokenLines);
        if (tokenLines.size() < 3) {
            this.log.error("unable to find the required lines (rule body, input parameters, output parameters) in rule body:{}", (Object)ruleAsPlainText);
            throw new JargonRuleException("Rule requires at least 3 lines for body, input, and output parameters");
        }
        List<IRODSRuleParameter> inputParameters = this.processRuleInputAttributesLine((String)tokenLines.get(tokenLines.size() - 2));
        if (overrideInputParameters != null) {
            this.log.info("will override parameters");
            inputParameters = this.collateOverridesIntoInputParameters(overrideInputParameters, inputParameters);
        }
        List<IRODSRuleParameter> outputParameters = this.processRuleOutputAttributesLine((String)tokenLines.get(tokenLines.size() - 1));
        IRODSRule irodsRule = IRODSRule.instance(ruleAsPlainText, inputParameters, outputParameters, ruleBody);
        return irodsRule;
    }

    protected List<IRODSRuleParameter> collateOverridesIntoInputParameters(List<IRODSRuleParameter> overrideInputParameters, List<IRODSRuleParameter> inputParameters) {
        boolean found;
        if (overrideInputParameters == null) {
            throw new IllegalArgumentException("null overrideInputParameters");
        }
        if (inputParameters == null) {
            throw new IllegalArgumentException("null inputParameters");
        }
        ArrayList<IRODSRuleParameter> overriddenParms = new ArrayList<IRODSRuleParameter>();
        for (IRODSRuleParameter current : inputParameters) {
            found = false;
            for (IRODSRuleParameter override : overrideInputParameters) {
                if (!current.getUniqueName().equals(override.getUniqueName())) continue;
                overriddenParms.add(override);
                found = true;
            }
            if (found) continue;
            overriddenParms.add(current);
        }
        for (IRODSRuleParameter override : overrideInputParameters) {
            found = false;
            for (IRODSRuleParameter current : overriddenParms) {
                if (!current.getUniqueName().equals(override.getUniqueName())) continue;
                found = true;
            }
            if (!found) {
                overriddenParms.add(override);
            }
            this.log.info("replacing original parms with overridden parms:{}", overriddenParms);
            inputParameters = overriddenParms;
        }
        return inputParameters;
    }

    static String processRuleBody(List<String> tokenLines) {
        StringBuilder total = new StringBuilder();
        int ctr = 0;
        for (String line : tokenLines) {
            if (ctr == tokenLines.size() - 2) break;
            total.append(line);
            total.append("\n");
            ++ctr;
        }
        return total.toString();
    }

    List<IRODSRuleParameter> processRuleOutputAttributesLine(String outputAttributesLine) throws JargonRuleException, JargonException {
        if (outputAttributesLine == null) {
            throw new JargonRuleException("null passed to output attributes parser");
        }
        if ((outputAttributesLine = outputAttributesLine.trim()).isEmpty()) {
            throw new JargonRuleException("outputAttributes line is blank");
        }
        int idxInput = outputAttributesLine.indexOf("OUTPUT");
        if (idxInput > -1) {
            outputAttributesLine = outputAttributesLine.substring(idxInput + 6);
        }
        if (outputAttributesLine.indexOf("**") > -1) {
            throw new JargonRuleException("blank attribute in output attributes line indicated by duplicate '*' delimiters with no data");
        }
        if (outputAttributesLine.indexOf("%%") > -1) {
            throw new JargonRuleException("blank attribute in output attributes line indicated by duplicate '%' delimiters with no data");
        }
        ArrayList<IRODSRuleParameter> outputAttributes = new ArrayList<IRODSRuleParameter>();
        StringTokenizer outputParmsTokenizer = null;
        outputParmsTokenizer = new StringTokenizer(outputAttributesLine, "%");
        while (outputParmsTokenizer.hasMoreTokens()) {
            outputAttributes.add(this.processOutputParmsToken(outputParmsTokenizer.nextToken().trim()));
        }
        return outputAttributes;
    }

    private IRODSRuleParameter processOutputParmsToken(String nextToken) throws JargonException, JargonRuleException {
        if (nextToken == null) {
            throw new JargonException("null nextToken");
        }
        if (nextToken.isEmpty()) {
            throw new JargonRuleException("output parms token is empty");
        }
        String parmName = nextToken;
        this.log.debug("returning outputParm: {}", (Object)parmName);
        return new IRODSRuleParameter(parmName, "");
    }

    List<IRODSRuleParameter> processRuleInputAttributesLine(String inputAttributesLine) throws JargonRuleException, JargonException {
        if (inputAttributesLine == null) {
            throw new JargonRuleException("null tokens passed to input attributes parser");
        }
        if ((inputAttributesLine = inputAttributesLine.trim()).isEmpty()) {
            throw new JargonRuleException("inputAttributesLine is empty");
        }
        int idxInput = inputAttributesLine.indexOf("INPUT");
        if (idxInput > -1) {
            inputAttributesLine = inputAttributesLine.substring(idxInput + 5).trim();
        }
        ArrayList<IRODSRuleParameter> inputAttributes = new ArrayList<IRODSRuleParameter>();
        if (inputAttributesLine.equals("null")) {
            if (this.irodsServerProperties.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0") && idxInput > -1) {
                this.log.info("no null prop for new format irods rules");
            } else {
                this.log.info("adding null param for old style rule");
                inputAttributes.add(new IRODSRuleParameter());
            }
            return inputAttributes;
        }
        if (inputAttributesLine.indexOf("%%") > -1) {
            throw new JargonRuleException("blank attribute in input attributes line indicated by duplicate '%' delimiters with no data");
        }
        StringTokenizer inputParmsTokenizer = null;
        inputParmsTokenizer = idxInput > -1 ? new StringTokenizer(inputAttributesLine, ",") : new StringTokenizer(inputAttributesLine, "%");
        while (inputParmsTokenizer.hasMoreTokens()) {
            inputAttributes.add(this.processInputParmsToken(inputParmsTokenizer.nextToken()));
        }
        return inputAttributes;
    }

    private IRODSRuleParameter processInputParmsToken(String nextToken) throws JargonRuleException, JargonException {
        if (nextToken == null) {
            throw new JargonException("null nextToken");
        }
        if (nextToken.isEmpty()) {
            throw new JargonRuleException("input parms token is empty");
        }
        if ((nextToken = nextToken.trim()).equals("null")) {
            throw new JargonRuleException("embedded 'null' in input attributes, must be the only value if null");
        }
        StringTokenizer nameValTokenizer = new StringTokenizer(nextToken, "=");
        if (nameValTokenizer.countTokens() != 2 && nameValTokenizer.countTokens() != 3) {
            throw new JargonRuleException("could not find name and val separated by an '=' sign in input attribute: " + nextToken);
        }
        String parmName = nameValTokenizer.nextToken();
        String val = nameValTokenizer.nextToken();
        if (parmName.indexOf(SPLAT) == -1) {
            throw new JargonRuleException("missing * in first character of input parameter:" + parmName);
        }
        if (parmName.indexOf(SPLAT) > 0) {
            throw new JargonRuleException("* must be the first character of input parameter:" + parmName);
        }
        if (parmName.indexOf(SPLAT, 1) > -1) {
            throw new JargonRuleException("duplicate '*' character in parm:" + parmName);
        }
        if (val.isEmpty()) {
            throw new JargonRuleException("value is null for input rule attribute:" + parmName);
        }
        if (nameValTokenizer.hasMoreTokens()) {
            StringBuilder newVal = new StringBuilder();
            newVal.append(val);
            newVal.append('=');
            newVal.append(nameValTokenizer.nextToken());
            val = newVal.toString();
        }
        this.log.debug("returning inputParm: {}", (Object)parmName);
        this.log.debug("parm value: {}", (Object)val);
        return new IRODSRuleParameter(parmName, val);
    }

    public static final boolean isUsingNewRuleSyntax(String ruleText) {
        if (ruleText == null || ruleText.isEmpty()) {
            throw new IllegalArgumentException("null or empty ruleText");
        }
        boolean isNew = false;
        if (ruleText.indexOf(124) == -1 && ruleText.indexOf(123) > -1) {
            isNew = true;
        }
        return isNew;
    }
}

