/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public abstract class AbstractParallelFileTransferStrategy {
    protected final String host;
    protected final int port;
    protected final int numberOfThreads;
    protected final int password;
    protected final File localFile;
    protected final long transferLength;
    private final IRODSAccessObjectFactory irodsAccessObjectFactory;
    private final TransferControlBlock transferControlBlock;
    private final TransferStatusCallbackListener transferStatusCallbackListener;
    private ConnectionProgressStatusListener connectionProgressStatusListener = null;
    private final int parallelSocketTimeoutInSecs;

    public abstract void transfer() throws JargonException;

    protected AbstractParallelFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (port < 1) {
            throw new IllegalArgumentException("port must be supplied");
        }
        if (numberOfThreads == 0) {
            throw new IllegalArgumentException("this is not a parallel transfer, the number of threads supplied is zero");
        }
        if (password <= 0) {
            throw new IllegalArgumentException("password is invalid");
        }
        if (localFile == null) {
            throw new IllegalArgumentException("Local file is null");
        }
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("irodsAccessObjectFactory is null");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        this.host = host;
        this.port = port;
        this.numberOfThreads = numberOfThreads;
        this.password = password;
        this.localFile = localFile;
        this.irodsAccessObjectFactory = irodsAccessObjectFactory;
        this.transferControlBlock = transferControlBlock;
        this.transferStatusCallbackListener = transferStatusCallbackListener;
        this.transferLength = transferLength;
        this.parallelSocketTimeoutInSecs = irodsAccessObjectFactory.getIrodsSession().getJargonProperties().getIRODSParallelTransferSocketTimeout();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parallel transfer operation:");
        sb.append("\n   host:");
        sb.append(this.host);
        sb.append("\n   port:");
        sb.append(this.port);
        sb.append("\n   numberOfThreads:");
        sb.append(this.numberOfThreads);
        sb.append("\n   localFile:");
        sb.append(this.localFile.getAbsolutePath());
        return sb.toString();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getPassword() {
        return this.password;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    protected IRODSAccessObjectFactory getIrodsAccessObjectFactory() {
        return this.irodsAccessObjectFactory;
    }

    protected TransferControlBlock getTransferControlBlock() {
        return this.transferControlBlock;
    }

    protected TransferStatusCallbackListener getTransferStatusCallbackListener() {
        return this.transferStatusCallbackListener;
    }

    protected synchronized ConnectionProgressStatusListener getConnectionProgressStatusListener() {
        return this.connectionProgressStatusListener;
    }

    protected synchronized void setConnectionProgressStatusListener(ConnectionProgressStatusListener connectionProgressStatusListener) {
        this.connectionProgressStatusListener = connectionProgressStatusListener;
    }

    protected long getTransferLength() {
        return this.transferLength;
    }

    protected int getParallelSocketTimeoutInSecs() {
        return this.parallelSocketTimeoutInSecs;
    }

    public static enum TransferType {
        GET_TRANSFER,
        PUT_TRANSFER;

    }
}

