/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.AbstractParallelFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelGetTransferThread;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelGetFileTransferStrategy
extends AbstractParallelFileTransferStrategy {
    public static final Logger log = LoggerFactory.getLogger(ParallelGetFileTransferStrategy.class);

    public static ParallelGetFileTransferStrategy instance(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        return new ParallelGetFileTransferStrategy(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener);
    }

    private ParallelGetFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        super(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener);
        log.info("transfer options in transfer control block:{}", transferControlBlock.getTransferOptions());
        if (transferStatusCallbackListener == null) {
            log.info("null transferStatusCallbackListener");
        }
        if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
            log.info("will do intra-file status callbacks from transfer");
            this.setConnectionProgressStatusListener(DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.GET, this.getTransferLength(), transferControlBlock, transferStatusCallbackListener));
        } else {
            log.info("transfer status callbacks will not be processed");
        }
    }

    @Override
    public void transfer() throws JargonException {
        log.info("initiating transfer for: {}", (Object)this.toString());
        ExecutorService executor = this.getIrodsAccessObjectFactory().getIrodsSession().getParallelTransferThreadPool();
        if (executor == null) {
            log.info("no pool available, transfer using standard Threads");
            this.transferWithoutExecutor();
        } else {
            log.info("transfer via executor");
            this.transferWithExecutor(executor);
        }
        log.info("transfer process has returned");
    }

    private void transferWithExecutor(ExecutorService executor) throws JargonException {
        ArrayList<ParallelGetTransferThread> parallelGetTransferThreads = new ArrayList<ParallelGetTransferThread>();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            ParallelGetTransferThread parallelTransfer = ParallelGetTransferThread.instance(this);
            parallelGetTransferThreads.add(parallelTransfer);
        }
        try {
            log.info("invoking executor threads for get");
            executor.invokeAll(parallelGetTransferThreads);
            log.info("executor completed");
        }
        catch (InterruptedException e) {
            log.error("interrupted exception in thread", e);
            throw new JargonException(e);
        }
    }

    private void transferWithoutExecutor() throws JargonException {
        ArrayList<Thread> transferRunningThreads = new ArrayList<Thread>();
        ArrayList<ParallelGetTransferThread> parallelGetTransferThreads = new ArrayList<ParallelGetTransferThread>();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            ParallelGetTransferThread parallelTransfer = ParallelGetTransferThread.instance(this);
            parallelGetTransferThreads.add(parallelTransfer);
            Thread parallelTransferThread = new Thread(parallelTransfer);
            log.info("created parallel transfer thread for thread: {}", (Object)parallelTransferThread.getName());
            transferRunningThreads.add(parallelTransferThread);
        }
        for (Thread parallelTransferThreadToStart : transferRunningThreads) {
            parallelTransferThreadToStart.start();
            log.info("started parallel transfer thread for thread: {}", (Object)parallelTransferThreadToStart.getName());
        }
        for (Thread parallelTransferThreadToJoin : transferRunningThreads) {
            if (!parallelTransferThreadToJoin.isAlive()) continue;
            try {
                parallelTransferThreadToJoin.join();
            }
            catch (InterruptedException e) {
                log.error("parallel transfer thread {} was interrupted when attempting to join", (Object)parallelTransferThreadToJoin.getName(), (Object)e);
                throw new JargonException("parallel transfer thread interrupted when attempting to join");
            }
        }
        log.info("closing threads...");
        for (ParallelGetTransferThread parallelGetTransferThread : parallelGetTransferThreads) {
            parallelGetTransferThread.close();
        }
        log.info("parallel transfer complete, checking for any errors in the threads...");
        for (ParallelGetTransferThread parallelGetTransferThread : parallelGetTransferThreads) {
            if (parallelGetTransferThread.getExceptionInTransfer() == null) continue;
            log.error("exeption detected in file transfer thread:{}", parallelGetTransferThread.getExceptionInTransfer());
            throw new JargonException("exception caught in transfer thread", parallelGetTransferThread.getExceptionInTransfer());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParallelGetFileTransferStrategy");
        sb.append("\n   host:");
        sb.append(this.getHost());
        sb.append("\n   port:");
        sb.append(this.getPort());
        sb.append("\n   numberOfThreads:");
        sb.append(this.getNumberOfThreads());
        sb.append("\n   localFile:");
        sb.append(this.localFile.getAbsolutePath());
        sb.append("\n   transferLength:");
        sb.append(this.transferLength);
        return sb.toString();
    }
}

