/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import org.irods.jargon.core.connection.ConnectionConstants;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.transfer.AbstractParallelTransferThread;
import org.irods.jargon.core.transfer.ParallelGetFileTransferStrategy;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelGetTransferThread
extends AbstractParallelTransferThread
implements Callable<Object>,
Runnable {
    private final ParallelGetFileTransferStrategy parallelGetFileTransferStrategy;
    public static final Logger log = LoggerFactory.getLogger(ParallelGetTransferThread.class);

    public static ParallelGetTransferThread instance(ParallelGetFileTransferStrategy parallelGetFileTransferStrategy) throws JargonException {
        return new ParallelGetTransferThread(parallelGetFileTransferStrategy);
    }

    private ParallelGetTransferThread(ParallelGetFileTransferStrategy parallelGetFileTransferStrategy) throws JargonException {
        if (parallelGetFileTransferStrategy == null) {
            throw new JargonException("parallelGetFileTransferStrategy is null");
        }
        this.parallelGetFileTransferStrategy = parallelGetFileTransferStrategy;
    }

    @Override
    public Object call() throws JargonException {
        try {
            this.setS(new Socket(this.parallelGetFileTransferStrategy.getHost(), this.parallelGetFileTransferStrategy.getPort()));
            if (this.parallelGetFileTransferStrategy.getParallelSocketTimeoutInSecs() > 0) {
                log.info("timeout (in seconds) for parallel transfer sockets is:{}", this.parallelGetFileTransferStrategy.getParallelSocketTimeoutInSecs());
                this.getS().setSoTimeout(this.parallelGetFileTransferStrategy.getParallelSocketTimeoutInSecs() * 1000);
            }
            byte[] outputBuffer = new byte[4];
            Host.copyInt(this.parallelGetFileTransferStrategy.getPassword(), outputBuffer);
            this.setIn(new BufferedInputStream(this.getS().getInputStream()));
            this.setOut(new BufferedOutputStream(this.getS().getOutputStream()));
            log.debug("socket established, sending cookie to iRODS listener");
            this.getOut().write(outputBuffer);
            this.getOut().flush();
            log.debug("cookie written");
            log.info("sockets are open and password sent, now begin the get operation");
            this.get();
            log.info("exiting get and returning the finish object");
            return "DONE";
        }
        catch (UnknownHostException e) {
            log.error("Unknown host: {}", (Object)this.parallelGetFileTransferStrategy.getHost());
            this.setExceptionInTransfer(e);
            throw new JargonException("unknown host:" + this.parallelGetFileTransferStrategy.getHost(), e);
        }
        catch (IOException e) {
            log.error("IOExeption in parallel transfer", (Object)this.parallelGetFileTransferStrategy.toString());
            this.setExceptionInTransfer(e);
            throw new JargonException("IOException occurred during parallel file transfer", e);
        }
    }

    public void get() throws JargonException {
        RandomAccessFile local;
        log.info("parallel transfer get");
        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() == null) {
            log.info("no connection progress status listener configured, no detailed callbacks");
        } else {
            log.info("connection listener configured, will produce callbacks");
        }
        try {
            log.info("opening local randomAccessFile");
            local = new RandomAccessFile(this.parallelGetFileTransferStrategy.getLocalFile(), "rw");
            log.info("random access file opened rw mode");
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException in parallel get operation", e);
            throw new JargonException("FileNotFoundException in parallel get operation", e);
        }
        try {
            this.processingLoopForGetData(local);
        }
        catch (JargonException je) {
            log.error("a jargon exception occurred in the get loop");
            throw je;
        }
        catch (Exception e) {
            log.error("Exception closing local file", e);
            throw new JargonException("IOException closing local file");
        }
        finally {
            log.info("parallel thread closing out local random access file stream");
            try {
                log.info("closing sockets, this close eats exceptions");
                this.close();
                log.info("closing local file");
                local.close();
                log.info("local file closed, exiting get() method");
            }
            catch (IOException e) {}
        }
    }

    private void processingLoopForGetData(RandomAccessFile local) throws JargonException {
        log.info("reading header info...");
        int operation = this.readInt();
        log.info("   operation:{}", operation);
        int flags = this.readInt();
        log.info("   flags:{}", flags);
        long offset = this.readLong();
        log.info("   offset:{}", offset);
        long length = this.readLong();
        log.info("   length:{}", length);
        byte[] buffer = null;
        int read = 0;
        if (operation != 2) {
            log.error("Parallel transfer expected GET,  server requested {}", operation);
            throw new JargonException("parallel get transfer, unexpected transfer type from iRODS:" + operation);
        }
        log.info("seeking to offset: {}", offset);
        try {
            if (length <= 0L) {
                return;
            }
            buffer = new byte[ConnectionConstants.OUTPUT_BUFFER_LENGTH];
            this.seekToOffset(local, offset);
            while (length > 0L) {
                log.debug("reading....");
                read = this.getIn().read(buffer, 0, Math.min(ConnectionConstants.OUTPUT_BUFFER_LENGTH, (int)length));
                log.debug("read={}", read);
                if (read > 0) {
                    log.debug("length left after read={}", length -= (long)read);
                    if (length == 0L) {
                        log.debug("length == 0, write the buffer, then get another header");
                        local.write(buffer, 0, read);
                        log.debug("buffer written to file");
                        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() != null) {
                            this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener().connectionProgressStatusCallback(ConnectionProgressStatus.instanceForReceive(read));
                        }
                        log.debug("parallel transfer read next header");
                        operation = this.readInt();
                        log.debug("   operation:{}", operation);
                        flags = this.readInt();
                        log.debug("   flags:{}", flags);
                        offset = this.readLong();
                        log.debug("   offset:{}", offset);
                        length = this.readLong();
                        log.debug("   length:{}", length);
                        if (operation == 9999) {
                            log.debug("    done...received done flag in operation");
                            break;
                        }
                        log.debug("seeking to new offset");
                        local.seek(offset);
                    } else {
                        if (length < 0L) {
                            String msg = "length < 0 passed in header from iRODS during parallel get operation";
                            log.error(msg);
                            throw new JargonException(msg);
                        }
                        log.debug("length > 0, write what I have and read more...");
                        local.write(buffer, 0, read);
                        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() != null) {
                            this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener().connectionProgressStatusCallback(ConnectionProgressStatus.instanceForReceive(read));
                        }
                        log.debug("buffer written to file");
                    }
                } else {
                    log.warn("intercepted a loop condition on parallel file get, length is > 0 but I just read and got nothing...breaking...");
                    throw new JargonException("possible loop condition in parallel file get");
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            log.error("IOExeption in parallel transfer", (Object)this.parallelGetFileTransferStrategy.toString());
            throw new JargonException("IOException occurred during parallel file transfer", e);
        }
        catch (Exception e) {
            log.error("exception in parallel transfer", e);
            throw new JargonException("unexpected exception in parallel transfer", e);
        }
    }

    private void seekToOffset(RandomAccessFile local, long offset) throws JargonException {
        if (offset < 0L) {
            log.error("offset < 0 in transfer get() operation, return from get method");
            return;
        }
        if (offset > 0L) {
            try {
                local.seek(offset);
                log.debug("seek completed");
            }
            catch (IOException e) {
                log.error("IOExeption in parallel transfer", (Object)this.parallelGetFileTransferStrategy.toString());
                throw new JargonException("IOException occurred during parallel file transfer", e);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.call();
            log.info("exiting call() method");
        }
        catch (Exception e) {
            this.setExceptionInTransfer(e);
            log.error("exception should have been preserved in the thread during the call()");
        }
    }
}

