/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelTools {
    private static final Logger log = LoggerFactory.getLogger(ChannelTools.class);

    public static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest, int bufferSize) throws IOException {
        log.info("fast channel copy on streams, buffer length set to:{}", bufferSize);
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        log.info("eof on stream");
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }
}

