/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.net.URI;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.URIUserParts;

public class IRODSUriUtils {
    private static final char PATH_SEPARATOR = '/';

    public static String getUserNameFromURI(URI irodsURI) {
        URIUserParts uriUserParts = IRODSUriUtils.getURIUserPartsFromUserInfo(irodsURI);
        return uriUserParts.getUserName();
    }

    protected static URIUserParts getURIUserPartsFromUserInfo(URI irodsURI) {
        String userInfo = irodsURI.getUserInfo();
        if (userInfo == null || userInfo.isEmpty()) {
            return null;
        }
        int indexColon = userInfo.indexOf(":");
        int indexDot = userInfo.indexOf(".");
        String userName = null;
        if (indexDot != -1 && (userName = userInfo.substring(0, indexDot)).isEmpty()) {
            userName = null;
        }
        String password = null;
        String zone = null;
        if (userName != null && indexColon != -1 && (password = userInfo.substring(indexColon + 1)).isEmpty()) {
            password = null;
        }
        if (indexColon == -1 && indexDot == -1) {
            if (!userInfo.isEmpty()) {
                zone = userInfo;
            }
        } else {
            int substrStart = 0;
            int substrEnd = userInfo.length();
            if (indexDot != -1) {
                substrStart = indexDot + 1;
            }
            if (indexColon != -1) {
                substrEnd = indexColon;
            }
            zone = userInfo.substring(substrStart, substrEnd);
        }
        URIUserParts uriUserParts = new URIUserParts();
        uriUserParts.setPassword(password);
        uriUserParts.setUserName(userName);
        uriUserParts.setZone(zone);
        return uriUserParts;
    }

    public static String getPasswordFromURI(URI irodsURI) {
        URIUserParts uriUserParts = IRODSUriUtils.getURIUserPartsFromUserInfo(irodsURI);
        return uriUserParts.getPassword();
    }

    public static String getZoneFromURI(URI irodsURI) {
        URIUserParts uriUserParts = IRODSUriUtils.getURIUserPartsFromUserInfo(irodsURI);
        return uriUserParts.getZone();
    }

    public static String getHostFromURI(URI irodsURI) {
        return irodsURI.getHost();
    }

    public static int getPortFromURI(URI irodsURI) {
        return irodsURI.getPort();
    }

    public static String getAbsolutePathFromURI(URI irodsURI) {
        return irodsURI.getPath();
    }

    public static IRODSAccount getIRODSAccountFromURI(URI irodsURI) throws JargonException {
        if (!IRODSUriUtils.isIRODSURIScheme(irodsURI)) {
            throw new JargonException("cannot derive IRODSAccount, not an iRODS uri");
        }
        URIUserParts uriUserParts = IRODSUriUtils.getURIUserPartsFromUserInfo(irodsURI);
        if (uriUserParts.getPassword() == null || uriUserParts.getUserName() == null || uriUserParts.getZone() == null) {
            throw new JargonException("No user information in URI, cannot create iRODS account");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(uriUserParts.getZone());
        sb.append('/');
        sb.append(uriUserParts.getUserName());
        return IRODSAccount.instance(irodsURI.getHost(), irodsURI.getPort(), uriUserParts.getUserName(), uriUserParts.getPassword(), sb.toString(), uriUserParts.getZone(), "");
    }

    public static boolean isIRODSURIScheme(URI irodsURI) {
        boolean isURI = false;
        String uriScheme = irodsURI.getScheme();
        if (uriScheme != null && uriScheme.equals("irods")) {
            isURI = true;
        }
        return isURI;
    }
}

