/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class DeltavisionReader
extends FormatReader {
    public static final int DV_MAGIC_BYTES_1 = 41152;
    public static final int DV_MAGIC_BYTES_2 = 49312;
    public static final String FIRST_PLANE_OFFSET = "Offset to first plane";
    public static final String DATE_FORMAT = "EEE MMM  d HH:mm:ss yyyy";
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    private int xTiles;
    private int yTiles;
    private boolean backwardsStage = false;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;
    private Double[] ndFilters;
    private int[] lengths;
    private String logFile;
    private String deconvolutionLogFile;
    private boolean truncatedFileFlag = false;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d", "dv.log", "r3d.log"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .dv, .r3d, or .d3d file and up to two optional .log files";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (DeltavisionReader.checkSuffix(name, "dv.log") || DeltavisionReader.checkSuffix(name, "r3d.log") || name.endsWith("_log.txt")) {
            return true;
        }
        if (DeltavisionReader.checkSuffix(name, "pnl")) {
            return false;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 98;
        if (!FormatTools.validStream(stream, 98, false)) {
            return false;
        }
        stream.seek(96L);
        int magic = stream.readShort() & 0xFFFF;
        return magic == 41152 || magic == 49312;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        if (!noPixels) {
            files.add(this.currentId);
        }
        if (this.logFile != null) {
            files.add(this.logFile);
        }
        if (this.deconvolutionLogFile != null) {
            files.add(this.deconvolutionLogFile);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] coords = this.getZCTCoords(no);
        long offset = this.getPlaneByteOffset(coords[0], coords[1], coords[2]);
        if (offset < this.in.length()) {
            this.in.seek(offset);
            this.readPlane(this.in, x, this.getSizeY() - h - y, w, h, buf);
            byte[] tmp = new byte[w * FormatTools.getBytesPerPixel(this.getPixelType())];
            for (int row = 0; row < h / 2; ++row) {
                int src = row * tmp.length;
                int dest = (h - row - 1) * tmp.length;
                System.arraycopy(buf, src, tmp, 0, tmp.length);
                System.arraycopy(buf, dest, buf, src, tmp.length);
                System.arraycopy(tmp, 0, buf, dest, tmp.length);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tSize = 0;
            this.zSize = 0;
            this.wSize = 0;
            this.extSize = 0;
            this.numFloatsPerSection = 0;
            this.numIntsPerSection = 0;
            this.extHdrFields = null;
            this.ndFilters = null;
            this.deconvolutionLogFile = null;
            this.logFile = null;
            this.lengths = null;
            this.backwardsStage = false;
            this.xTiles = 0;
            this.yTiles = 0;
        }
    }

    public void setTruncatedFileFlag(boolean truncatedFileFlag) {
        FormatTools.assertId(this.currentId, false, 1);
        this.truncatedFileFlag = truncatedFileFlag;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!DeltavisionReader.checkSuffix(id, "dv")) {
            if (DeltavisionReader.checkSuffix(id, "dv.log") || DeltavisionReader.checkSuffix(id, "r3d.log")) {
                id = id.substring(0, id.lastIndexOf("."));
            } else if (id.endsWith("_log.txt")) {
                id = id.substring(0, id.lastIndexOf("_")) + ".dv";
            }
            Location file2 = new Location(id).getAbsoluteFile();
            if (!file2.exists()) {
                Location dir = file2.getParentFile();
                String[] list = dir.list(true);
                String name = file2.getName();
                name = name.substring(0, name.lastIndexOf("."));
                for (String f : list) {
                    if (!DeltavisionReader.checkSuffix(f, "dv") || !f.startsWith(name)) continue;
                    id = new Location(dir, f).getAbsolutePath();
                    break;
                }
            }
        }
        super.initFile(id);
        this.findLogFiles();
        this.in = new RandomAccessInputStream(this.currentId);
        this.initPixels();
        MetadataLevel metadataLevel = this.metadataOptions.getMetadataLevel();
        if (metadataLevel != MetadataLevel.MINIMUM) {
            this.initExtraMetadata();
        }
    }

    protected void initPixels() throws FormatException, IOException {
        int nStagePositions;
        LOGGER.info("Reading header");
        MetadataStore store = this.makeFilterMetadata();
        this.in.seek(96L);
        this.in.order(true);
        boolean little = this.in.readShort() == -16224;
        this.in.order(little);
        this.in.seek(0L);
        int sizeX = this.in.readInt();
        int sizeY = this.in.readInt();
        int imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.in.seek(180L);
        int rawSizeT = this.in.readShort();
        int sizeT = rawSizeT == 0 ? 1 : rawSizeT;
        short sequence = this.in.readShort();
        this.in.seek(92L);
        this.extSize = this.in.readInt();
        this.in.seek(196L);
        short rawSizeC = this.in.readShort();
        short sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
        String imageSequence = this.getImageSequence(sequence);
        int sizeZ = imageCount / (sizeC * sizeT);
        LOGGER.info("Populating core metadata");
        this.core[0].littleEndian = little;
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].imageCount = imageCount;
        String pixel = this.getPixelString(filePixelType);
        this.core[0].pixelType = this.getPixelType(filePixelType);
        this.core[0].dimensionOrder = "XY" + imageSequence.replaceAll("W", "C");
        int planeSize = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType());
        int realPlaneCount = (int)((this.in.length() - 1024L - (long)this.extSize) / (long)planeSize);
        if (realPlaneCount < this.getImageCount() && !this.truncatedFileFlag) {
            LOGGER.debug("Truncated file");
            this.core[0].imageCount = realPlaneCount;
            if (sizeZ == 1) {
                sizeT = realPlaneCount / sizeC;
            } else if (sizeT == 1) {
                sizeZ = realPlaneCount / sizeC;
                if (realPlaneCount % sizeC != 0) {
                    this.core[0].imageCount = ++sizeZ * sizeC;
                }
            } else if (this.getDimensionOrder().indexOf("Z") < this.getDimensionOrder().indexOf("T")) {
                sizeZ = realPlaneCount / (sizeC * sizeT);
                if (sizeZ == 0) {
                    sizeT = 1;
                    sizeZ = realPlaneCount / sizeC;
                    if (realPlaneCount % sizeC != 0) {
                        this.core[0].imageCount = ++sizeZ * sizeC;
                    }
                }
                if (this.getImageCount() > sizeZ * sizeC * sizeT) {
                    this.core[0].imageCount = imageCount;
                    sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
                    sizeT = rawSizeT == 0 ? 1 : rawSizeT;
                    sizeZ = this.getImageCount() / (sizeC * sizeT);
                }
            } else {
                sizeT = realPlaneCount / (sizeC * sizeZ);
            }
        }
        this.core[0].sizeT = sizeT;
        this.core[0].sizeC = sizeC;
        this.core[0].sizeZ = sizeZ;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        LOGGER.info("Reading extended header");
        this.setOffsetInfo(sequence, this.getSizeZ(), this.getSizeC(), this.getSizeT());
        this.extHdrFields = new DVExtHdrFields[this.getSizeZ()][this.getSizeC()][this.getSizeT()];
        this.ndFilters = new Double[this.getSizeC()];
        Vector<Float> uniqueTileX = new Vector<Float>();
        Vector<Float> uniqueTileY = new Vector<Float>();
        int offset = 1024 + this.numIntsPerSection * 4;
        for (int i = 0; i < this.getImageCount(); ++i) {
            DVExtHdrFields hdr;
            int[] coords = this.getZCTCoords(i);
            int z = coords[0];
            int w = coords[1];
            int t = coords[2];
            this.in.seek(offset + this.getTotalOffset(z, w, t));
            this.extHdrFields[z][w][t] = hdr = new DVExtHdrFields(this.in);
            if (!uniqueTileX.contains(Float.valueOf(hdr.stageXCoord))) {
                uniqueTileX.add(Float.valueOf(hdr.stageXCoord));
            }
            if (uniqueTileY.contains(Float.valueOf(hdr.stageYCoord))) continue;
            uniqueTileY.add(Float.valueOf(hdr.stageYCoord));
        }
        this.xTiles = uniqueTileX.size();
        this.yTiles = uniqueTileY.size();
        if (this.yTiles > 1 && ((Float)uniqueTileY.get(1)).floatValue() < ((Float)uniqueTileY.get(0)).floatValue()) {
            this.backwardsStage = true;
        }
        if ((nStagePositions = this.xTiles * this.yTiles) > 0 && nStagePositions <= this.getSizeT()) {
            int t = this.getSizeT();
            this.core[0].sizeT /= nStagePositions;
            if (this.getSizeT() * nStagePositions != t) {
                this.core[0].sizeT = t;
                nStagePositions = 1;
            } else {
                this.core[0].imageCount /= nStagePositions;
            }
            if (nStagePositions > 1) {
                CoreMetadata originalCore = this.core[0];
                this.core = new CoreMetadata[nStagePositions];
                for (int i = 0; i < this.core.length; ++i) {
                    this.core[i] = originalCore;
                }
            }
        }
        this.lengths = new int[4];
        int lengthIndex = 0;
        int dimIndex = 0;
        while (lengthIndex < this.lengths.length) {
            char dim = imageSequence.charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    this.lengths[lengthIndex++] = this.getSizeZ();
                    break;
                }
                case 'W': {
                    this.lengths[lengthIndex++] = this.getSizeC();
                    break;
                }
                case 'T': {
                    this.lengths[lengthIndex++] = this.getSeriesCount();
                    this.lengths[lengthIndex++] = this.getSizeT();
                }
            }
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta(FIRST_PLANE_OFFSET, 1024 + this.extSize);
        this.addGlobalMeta("ImageWidth", sizeX);
        this.addGlobalMeta("ImageHeight", sizeY);
        this.addGlobalMeta("NumberOfImages", imageCount);
        this.addGlobalMeta("PixelType", pixel);
        this.addGlobalMeta("Number of timepoints", rawSizeT);
        this.addGlobalMeta("Image sequence", imageSequence);
        this.addGlobalMeta("Number of wavelengths", (int)rawSizeC);
        this.addGlobalMeta("Number of focal planes", sizeZ);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            this.setSeries(series);
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                int[] coords = this.getZCTCoords(plane);
                int tIndex = this.getSeriesCount() * coords[2] + series;
                DVExtHdrFields hdr = this.extHdrFields[coords[0]][coords[1]][tIndex];
                String prefix = "Extended header Z" + coords[0] + " W" + coords[1] + " T" + coords[2];
                this.addSeriesMeta(prefix, hdr);
                String position = " position for position #" + (series + 1);
                this.addGlobalMeta("X" + position, hdr.stageXCoord);
                this.addGlobalMeta("Y" + position, hdr.stageYCoord);
                this.addGlobalMeta("Z" + position, hdr.stageZCoord);
            }
        }
        this.setSeries(0);
        LOGGER.info("Populating OME metadata");
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageInstrumentRef(instrumentID, i);
        }
    }

    protected void initExtraMetadata() throws FormatException, IOException {
        boolean logFound;
        int i;
        MetadataStore store = this.makeFilterMetadata();
        LOGGER.info("Reading header");
        this.in.seek(16L);
        int subImageStartX = this.in.readInt();
        int subImageStartY = this.in.readInt();
        int subImageStartZ = this.in.readInt();
        int pixelSamplingX = this.in.readInt();
        int pixelSamplingY = this.in.readInt();
        int pixelSamplingZ = this.in.readInt();
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        float xAxisAngle = this.in.readFloat();
        float yAxisAngle = this.in.readFloat();
        float zAxisAngle = this.in.readFloat();
        int xAxisSeq = this.in.readInt();
        int yAxisSeq = this.in.readInt();
        int zAxisSeq = this.in.readInt();
        float[] minWave = new float[5];
        float[] maxWave = new float[5];
        minWave[0] = this.in.readFloat();
        maxWave[0] = this.in.readFloat();
        float meanIntensity = this.in.readFloat();
        int spaceGroupNumber = this.in.readInt();
        this.in.seek(132L);
        short numSubResSets = this.in.readShort();
        short zAxisReductionQuotient = this.in.readShort();
        for (int i2 = 1; i2 <= 3; ++i2) {
            minWave[i2] = this.in.readFloat();
            maxWave[i2] = this.in.readFloat();
        }
        short type = this.in.readShort();
        short lensID = this.in.readShort();
        this.in.seek(172L);
        minWave[4] = this.in.readFloat();
        maxWave[4] = this.in.readFloat();
        this.in.seek(184L);
        float xTiltAngle = this.in.readFloat();
        float yTiltAngle = this.in.readFloat();
        float zTiltAngle = this.in.readFloat();
        this.in.skipBytes(2);
        short[] waves = new short[5];
        for (int i3 = 0; i3 < waves.length; ++i3) {
            waves[i3] = this.in.readShort();
        }
        float xOrigin = this.in.readFloat();
        float yOrigin = this.in.readFloat();
        float zOrigin = this.in.readFloat();
        this.in.skipBytes(4);
        String[] title = new String[10];
        for (int i4 = 0; i4 < title.length; ++i4) {
            title[i4] = this.in.readString(80).replaceAll("\u0000", "");
        }
        String imageType = type < IMAGE_TYPES.length ? IMAGE_TYPES[type] : "unknown";
        String imageDesc = title[0];
        if (imageDesc != null && imageDesc.length() == 0) {
            imageDesc = null;
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta("Sub-image starting point (X)", subImageStartX);
        this.addGlobalMeta("Sub-image starting point (Y)", subImageStartY);
        this.addGlobalMeta("Sub-image starting point (Z)", subImageStartZ);
        this.addGlobalMeta("Pixel sampling size (X)", pixelSamplingX);
        this.addGlobalMeta("Pixel sampling size (Y)", pixelSamplingY);
        this.addGlobalMeta("Pixel sampling size (Z)", pixelSamplingZ);
        this.addGlobalMeta("X element length (in um)", pixX);
        this.addGlobalMeta("Y element length (in um)", pixY);
        this.addGlobalMeta("Z element length (in um)", pixZ);
        this.addGlobalMeta("X axis angle", xAxisAngle);
        this.addGlobalMeta("Y axis angle", yAxisAngle);
        this.addGlobalMeta("Z axis angle", zAxisAngle);
        this.addGlobalMeta("Column axis sequence", xAxisSeq);
        this.addGlobalMeta("Row axis sequence", yAxisSeq);
        this.addGlobalMeta("Section axis sequence", zAxisSeq);
        this.addGlobalMeta("Image Type", imageType);
        this.addGlobalMeta("Lens ID Number", (int)lensID);
        this.addGlobalMeta("X axis tilt angle", xTiltAngle);
        this.addGlobalMeta("Y axis tilt angle", yTiltAngle);
        this.addGlobalMeta("Z axis tilt angle", zTiltAngle);
        for (i = 0; i < waves.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " (in nm)", waves[i]);
        }
        this.addGlobalMeta("X origin (in um)", xOrigin);
        this.addGlobalMeta("Y origin (in um)", yOrigin);
        this.addGlobalMeta("Z origin (in um)", zOrigin);
        for (i = 0; i < title.length; ++i) {
            this.addGlobalMeta("Title " + (i + 1), title[i]);
        }
        for (i = 0; i < minWave.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " min. intensity", minWave[i]);
            this.addGlobalMeta("Wavelength " + (i + 1) + " max. intensity", maxWave[i]);
        }
        this.addGlobalMeta("Wavelength 1 mean intensity", meanIntensity);
        this.addGlobalMeta("Space group number", spaceGroupNumber);
        this.addGlobalMeta("Number of Sub-resolution sets", numSubResSets);
        this.addGlobalMeta("Z axis reduction quotient", zAxisReductionQuotient);
        LOGGER.info("Populating OME metadata");
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            if (store instanceof IMinMaxStore) {
                IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
                for (int i5 = 0; i5 < minWave.length; ++i5) {
                    if (i5 >= this.getEffectiveSizeC()) continue;
                    minMaxStore.setChannelGlobalMinMax(i5, minWave[i5], maxWave[i5], series);
                }
            }
            if (pixX > 0.0f) {
                Double x = new Double(pixX);
                store.setPixelsPhysicalSizeX(new PositiveFloat(x), series);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", Float.valueOf(pixX));
            }
            if (pixY > 0.0f) {
                Double y = new Double(pixY);
                store.setPixelsPhysicalSizeY(new PositiveFloat(y), series);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", Float.valueOf(pixY));
            }
            if (pixZ > 0.0f) {
                Double z = new Double(pixZ);
                store.setPixelsPhysicalSizeZ(new PositiveFloat(z), series);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", Float.valueOf(pixZ));
            }
            store.setImageDescription(imageDesc, series);
        }
        this.populateObjective(store, lensID);
        boolean bl = logFound = this.isGroupFiles() ? this.parseLogFile(store) : false;
        if (this.isGroupFiles()) {
            this.parseDeconvolutionLog(store);
        }
        if (this.getSeriesCount() == 1) {
            this.xTiles = 1;
            this.yTiles = 1;
            this.backwardsStage = false;
        }
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            int seriesIndex = series;
            if (this.backwardsStage) {
                int x = series % this.xTiles;
                int y = series / this.xTiles;
                seriesIndex = (this.yTiles - y - 1) * this.xTiles + (this.xTiles - x - 1);
            }
            for (int i6 = 0; i6 < this.getImageCount(); ++i6) {
                int[] coords = this.getZCTCoords(i6);
                int tIndex = this.getSeriesCount() * coords[2] + seriesIndex;
                DVExtHdrFields hdr = this.extHdrFields[coords[0]][coords[1]][tIndex];
                store.setPlaneDeltaT(new Double(hdr.timeStampSeconds), series, i6);
                store.setPlaneExposureTime(new Double(this.extHdrFields[0][coords[1]][0].expTime), series, i6);
                if (logFound && this.getSeriesCount() <= 1) continue;
                store.setPlanePositionX(new Double(hdr.stageXCoord), series, i6);
                store.setPlanePositionY(new Double(hdr.stageYCoord), series, i6);
                store.setPlanePositionZ(new Double(hdr.stageZCoord), series, i6);
            }
            for (int w = 0; w < this.getSizeC(); ++w) {
                DVExtHdrFields hdrC = this.extHdrFields[0][w][series];
                if (waves[w] > 0) {
                    store.setChannelEmissionWavelength(new PositiveInteger(Integer.valueOf(waves[w])), series, w);
                } else {
                    LOGGER.warn("Expected positive value for EmissionWavelength; got {}", waves[w]);
                }
                if ((int)hdrC.exWavelen > 0) {
                    store.setChannelExcitationWavelength(new PositiveInteger((int)hdrC.exWavelen), series, w);
                } else {
                    LOGGER.warn("Expected positive alue for ExcitationWavelength; got {}", Float.valueOf(hdrC.exWavelen));
                }
                if (this.ndFilters[w] == null) {
                    this.ndFilters[w] = new Double(hdrC.ndFilter);
                }
                store.setChannelNDFilter(this.ndFilters[w], series, w);
            }
        }
    }

    private String getPixelString(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return "8 bit unsigned integer";
            }
            case 1: {
                return "16 bit signed integer";
            }
            case 2: {
                return "32 bit floating point";
            }
            case 3: {
                return "16 bit complex";
            }
            case 4: {
                return "64 bit complex";
            }
            case 6: {
                return "16 bit unsigned integer";
            }
        }
        return "unknown";
    }

    private int getPixelType(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 3;
            }
        }
        return 1;
    }

    private String getImageSequence(int imageSequence) {
        switch (imageSequence) {
            case 0: {
                return "ZTW";
            }
            case 1: {
                return "WZT";
            }
            case 2: {
                return "ZWT";
            }
            case 65536: {
                return "WZT";
            }
        }
        return "ZTW";
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    public long getPlaneByteOffset(int currentZ, int currentW, int currentT) {
        FormatTools.assertId(this.currentId, true, 1);
        int[] newCoords = new int[4];
        int coordIndex = 0;
        int dimIndex = 2;
        while (coordIndex < newCoords.length) {
            char dim = this.getDimensionOrder().charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    newCoords[coordIndex++] = currentZ;
                    break;
                }
                case 'C': {
                    newCoords[coordIndex++] = currentW;
                    break;
                }
                case 'T': {
                    newCoords[coordIndex++] = this.getSeries();
                    newCoords[coordIndex++] = currentT;
                }
            }
        }
        int planeIndex = FormatTools.positionToRaster(this.lengths, newCoords);
        long planeSize = FormatTools.getPlaneSize(this);
        long planeOffset = planeSize * (long)planeIndex;
        long offset = planeOffset + 1024L + (long)this.extSize;
        return offset;
    }

    private void findLogFiles() throws IOException {
        if (this.getCurrentFile().lastIndexOf(".") == -1) {
            this.logFile = null;
            this.deconvolutionLogFile = null;
            return;
        }
        if (this.getCurrentFile().endsWith("_D3D.dv")) {
            this.logFile = this.getCurrentFile();
            this.logFile = this.logFile.substring(0, this.logFile.indexOf("_D3D.dv")) + ".dv.log";
        } else {
            this.logFile = this.getCurrentFile() + ".log";
            if (!new Location(this.logFile).exists()) {
                this.logFile = this.getCurrentFile();
                this.logFile = this.logFile.substring(0, this.logFile.lastIndexOf(".")) + ".log";
            }
        }
        if (!new Location(this.logFile).exists()) {
            this.logFile = null;
        }
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        this.deconvolutionLogFile = base + "_log.txt";
        if (!new Location(this.deconvolutionLogFile).exists()) {
            this.deconvolutionLogFile = null;
        }
    }

    private boolean parseLogFile(MetadataStore store) throws FormatException, IOException {
        if (this.logFile == null || !new Location(this.logFile).exists()) {
            this.logFile = null;
            return false;
        }
        LOGGER.info("Parsing log file");
        String[] lines = DataTools.readFile(this.logFile).split("[\r\n]");
        String value = "";
        String prefix = "";
        int currentImage = 0;
        for (String line : lines) {
            String date;
            int colon = line.indexOf(":");
            if (colon != -1) {
                String key;
                if (line.startsWith("Created")) {
                    key = "Created";
                    colon = 6;
                } else {
                    key = line.substring(0, colon).trim();
                }
                value = line.substring(colon + 1).trim();
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addGlobalMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(" ");
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = "";
                    String na = "";
                    if (tokens.length >= 1) {
                        int start;
                        int end = tokens[0].indexOf("X");
                        if (end > 0) {
                            magnification = tokens[0].substring(0, end);
                        }
                        if ((start = tokens[0].indexOf("/")) >= 0) {
                            na = tokens[0].substring(start + 1);
                        }
                    }
                    try {
                        Integer mag = new Integer(magnification);
                        if (mag > 0) {
                            store.setObjectiveNominalMagnification(new PositiveInteger(mag), 0, 0);
                        } else {
                            LOGGER.warn("Expected positive value for NominalMagnification; got {}", mag);
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse magnification '{}'", (Object)magnification);
                    }
                    try {
                        store.setObjectiveLensNA(new Double(na), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse N.A. '{}'", (Object)na);
                    }
                    if (tokens.length >= 2) {
                        store.setObjectiveCorrection(this.getCorrection(tokens[1]), 0, 0);
                    }
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equalsIgnoreCase("Lens ID")) {
                    if (value.indexOf(",") != -1) {
                        value = value.substring(0, value.indexOf(","));
                    }
                    if (value.indexOf(" ") != -1) {
                        value = value.substring(value.indexOf(" ") + 1);
                    }
                    if (value.equals("null")) continue;
                    String objectiveID = "Objective:" + value;
                    store.setObjectiveID(objectiveID, 0, 0);
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        store.setObjectiveSettingsID(objectiveID, series);
                    }
                    store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
                    store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    for (int q = 0; q < pixelSizes.length; ++q) {
                        Double size = null;
                        try {
                            size = new Double(pixelSizes[q].trim());
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("Could not parse pixel size '{}'", (Object)pixelSizes[q].trim());
                        }
                        if (size == null || size <= 0.0) {
                            LOGGER.warn("Expected positive value for PhysicalSize; got {}", size);
                            continue;
                        }
                        if (q == 0) {
                            for (int series = 0; series < this.getSeriesCount(); ++series) {
                                store.setPixelsPhysicalSizeX(new PositiveFloat(size), series);
                            }
                        }
                        if (q == 1) {
                            for (int series = 0; series < this.getSeriesCount(); ++series) {
                                store.setPixelsPhysicalSizeY(new PositiveFloat(size), series);
                            }
                        }
                        if (q != 2) continue;
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            store.setPixelsPhysicalSizeZ(new PositiveFloat(size), series);
                        }
                    }
                    continue;
                }
                if (key.equals("Binning")) {
                    store.setDetectorType(this.getDetectorType("Other"), 0, 0);
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            store.setDetectorSettingsBinning(this.getBinning(value), series, c);
                            store.setDetectorSettingsID(detectorID, series, c);
                        }
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    try {
                        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                        store.setDetectorID(detectorID, 0, 0);
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsGain(new Double(value), series, c);
                                store.setDetectorSettingsID(detectorID, series, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse gain '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Speed")) {
                    value = value.replaceAll("KHz", "");
                    try {
                        double mhz = Double.parseDouble(value) / 1000.0;
                        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                        store.setDetectorID(detectorID, 0, 0);
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsReadOutRate(mhz, series, c);
                                store.setDetectorSettingsID(detectorID, series, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse read-out rate '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    continue;
                }
                if (key.equals("EM filter")) {
                    int cIndex = 0;
                    try {
                        cIndex = this.getZCTCoords(currentImage)[1];
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("", e);
                    }
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        store.setChannelName(value, series, cIndex);
                    }
                    continue;
                }
                if (key.equals("ND filter")) {
                    value = value.replaceAll("%", "");
                    try {
                        int cIndex = this.getZCTCoords(currentImage)[1];
                        double nd = Double.parseDouble(value);
                        this.ndFilters[cIndex] = new Double(nd / 100.0);
                    }
                    catch (NumberFormatException exc) {
                        LOGGER.warn("Could not parse ND filter '{}'", (Object)value);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("", e);
                    }
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                if (value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] coords = value.split(",");
                for (int i = 0; i < coords.length; ++i) {
                    Double p = null;
                    try {
                        p = new Double(coords[i].trim());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse stage coordinate '{}'", (Object)coords[i]);
                    }
                    if (currentImage >= this.getImageCount() || this.getSeriesCount() != 1) continue;
                    if (i == 0) {
                        store.setPlanePositionX(p, 0, currentImage);
                    }
                    if (i == 1) {
                        store.setPlanePositionY(p, 0, currentImage);
                    }
                    if (i != 2) continue;
                    store.setPlanePositionZ(p, 0, currentImage);
                }
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (!line.startsWith("Created")) continue;
            if (line.length() > 8) {
                line = line.substring(8).trim();
            }
            if ((date = DateTools.formatDate(line, DATE_FORMAT)) != null) {
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    store.setImageAcquisitionDate(new Timestamp(date), series);
                }
                continue;
            }
            LOGGER.warn("Could not parse date '{}'", (Object)line);
        }
        return true;
    }

    private void parseDeconvolutionLog(MetadataStore store) throws IOException {
        if (this.deconvolutionLogFile == null || !new Location(this.deconvolutionLogFile).exists()) {
            return;
        }
        LOGGER.info("Parsing deconvolution log file");
        RandomAccessInputStream s = new RandomAccessInputStream(this.deconvolutionLogFile);
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s.getFilePointer() < s.length() - 1L) {
            int index;
            String line = s.readLine();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                Vector<String> realKeys = new Vector<String>();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = keys[i].trim();
                    if (keys[i].length() <= 0) continue;
                    realKeys.add(keys[i]);
                }
                keys = realKeys.toArray(new String[0]);
                s.readLine();
                line = s.readLine().trim();
                while (line != null && line.length() != 0) {
                    String[] values = line.split(" ");
                    Vector<String> realValues = new Vector<String>();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                        if (values[i].length() <= 0) continue;
                        realValues.add(values[i]);
                    }
                    values = realValues.toArray(new String[0]);
                    try {
                        if (values.length > 0) {
                            int zz = Integer.parseInt(values[0]) - 1;
                            int index2 = this.getIndex(zz, cc, tt);
                            for (int i = 1; i < keys.length; ++i) {
                                this.addGlobalMeta("Plane " + index2 + " " + keys[i], values[i]);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse Z position '{}'", (Object)values[0]);
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("", iae);
                    }
                    line = s.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine != null && (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF"))) {
                        this.addGlobalMeta(previousLine + " " + key, value);
                    } else {
                        this.addGlobalMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point\t") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                try {
                    tt = Integer.parseInt(t) - 1;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse timepoint '{}'", (Object)t);
                }
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    try {
                        cc = Integer.parseInt(c) - 1;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse channel position '{}'", (Object)c);
                    }
                }
            }
            if (line.length() > 0 && line.indexOf(".") == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
        s.close();
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min = this.in.readFloat();
        float max = this.in.readFloat();
        this.addGlobalMeta("Wavelength " + (channel + 1) + " min. intensity", min);
        this.addGlobalMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(channel, min, max, 0);
        }
    }

    private void populateObjective(MetadataStore store, int lensID) throws FormatException {
        Double lensNA = null;
        Double workingDistance = null;
        Immersion immersion = this.getImmersion("Other");
        Correction correction = this.getCorrection("Other");
        String manufacturer = null;
        String model = null;
        int magnification = 0;
        Double calibratedMagnification = null;
        if (lensID >= 10000 && lensID <= 32000) {
            if (lensID < 12000) {
                manufacturer = "Olympus";
            } else if (lensID < 14000) {
                manufacturer = "Nikon";
            } else if (lensID < 16000) {
                manufacturer = "Zeiss";
            } else if (lensID < 18000) {
                manufacturer = "Leica";
            } else if (lensID < 20000) {
                manufacturer = "APLLC";
            }
            magnification = (lensID % 1000 - lensID % 100) / 10;
            if (magnification == 0) {
                magnification = 100;
            }
        }
        switch (lensID) {
            case 2001: {
                lensNA = 1.15;
                immersion = this.getImmersion("Water");
                break;
            }
            case 10100: {
                lensNA = 0.3;
                immersion = this.getImmersion("Air");
                model = "1-LP134";
                correction = this.getCorrection("Achromat");
                break;
            }
            case 10101: {
                lensNA = 0.4;
                immersion = this.getImmersion("Air");
                model = "1-LB331";
                correction = this.getCorrection("Apo");
                break;
            }
            case 10102: {
                lensNA = 0.3;
                immersion = this.getImmersion("Air");
                model = "1-LP134";
                break;
            }
            case 10103: {
                lensNA = 0.13;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                model = "1-LP124";
                break;
            }
            case 10104: {
                lensNA = 0.4;
                immersion = this.getImmersion("Air");
                model = "1-LB331";
                break;
            }
            case 10105: {
                lensNA = 0.4;
                workingDistance = 3.1;
                immersion = this.getImmersion("Air");
                model = "1-LP331";
                break;
            }
            case 10106: {
                lensNA = 0.16;
                calibratedMagnification = 4.0;
                workingDistance = 13.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "1-UB822";
                break;
            }
            case 10107: {
                lensNA = 0.4;
                immersion = this.getImmersion("Air");
                workingDistance = 3.1;
                model = "1-UB823";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10108: {
                lensNA = 0.25;
                workingDistance = 9.8;
                immersion = this.getImmersion("Air");
                model = "1-UC243";
                break;
            }
            case 10109: {
                lensNA = 0.3;
                immersion = this.getImmersion("Air");
                model = "1-UB532";
                correction = this.getCorrection("PlanFluor");
                break;
            }
            case 10110: {
                lensNA = 0.13;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 10111: {
                lensNA = 0.08;
                calibratedMagnification = 2.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 10112: {
                lensNA = 0.13;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                model = "1-UB522";
                break;
            }
            case 10113: {
                lensNA = 0.04;
                calibratedMagnification = 1.25;
                workingDistance = 5.1;
                immersion = this.getImmersion("Air");
                model = "1-UB920";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10114: {
                lensNA = 0.08;
                calibratedMagnification = 2.0;
                workingDistance = 6.0;
                immersion = this.getImmersion("Air");
                model = "1-UB921";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10200: {
                lensNA = 0.4;
                workingDistance = 3.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 10201: {
                lensNA = 0.65;
                workingDistance = 1.03;
                immersion = this.getImmersion("Air");
                model = "1-LB343";
                correction = this.getCorrection("Apo");
                break;
            }
            case 10202: {
                lensNA = 0.4;
                immersion = this.getImmersion("Air");
                model = "1-LP146";
                break;
            }
            case 10203: {
                lensNA = 0.8;
                immersion = this.getImmersion("Oil");
                model = "1-LB342";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10204: {
                lensNA = 0.7;
                immersion = this.getImmersion("Air");
                model = "1-LB341";
                break;
            }
            case 10205: {
                lensNA = 0.75;
                workingDistance = 0.55;
                immersion = this.getImmersion("Air");
                model = "1-UB765";
                correction = this.getCorrection("Apo");
                break;
            }
            case 10206: {
                lensNA = 0.5;
                workingDistance = 0.55;
                immersion = this.getImmersion("Air");
                model = "1-UC525";
                break;
            }
            case 10207: {
                lensNA = 0.4;
                workingDistance = 3.0;
                immersion = this.getImmersion("Air");
                model = "1-UC145";
                correction = this.getCorrection("Achromat");
                break;
            }
            case 10208: {
                lensNA = 0.5;
                workingDistance = 0.55;
                immersion = this.getImmersion("Air");
                model = "1-UB525";
                break;
            }
            case 10209: {
                lensNA = 0.4;
                workingDistance = 6.9;
                immersion = this.getImmersion("Air");
                model = "1-UC345";
                break;
            }
            case 10210: {
                lensNA = 0.4;
                workingDistance = 6.9;
                immersion = this.getImmersion("Air");
                model = "1-UB345";
                break;
            }
            case 10400: {
                lensNA = 0.55;
                workingDistance = 2.04;
                immersion = this.getImmersion("Air");
                break;
            }
            case 10401: {
                lensNA = 0.85;
                workingDistance = 0.25;
                immersion = this.getImmersion("Air");
                break;
            }
            case 10402: {
                lensNA = 1.3;
                workingDistance = 0.12;
                immersion = this.getImmersion("Oil");
                model = "1-LB356";
                break;
            }
            case 10403: {
                lensNA = 1.35;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                model = "1-UB768";
                break;
            }
            case 10404: {
                lensNA = 0.85;
                workingDistance = 0.2;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "1-UB827";
                break;
            }
            case 10405: {
                lensNA = 0.95;
                workingDistance = 0.14;
                immersion = this.getImmersion("Air");
                model = "1-UB927";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10406: {
                lensNA = 1.0;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "1-UB828";
                break;
            }
            case 10407: {
                lensNA = 0.75;
                correction = this.getCorrection("PlanFluor");
                immersion = this.getImmersion("Air");
                model = "1-UB527";
                break;
            }
            case 10408: {
                lensNA = 0.6;
                workingDistance = 2.15;
                immersion = this.getImmersion("Air");
                model = "1-UB347";
                break;
            }
            case 10409: {
                lensNA = 0.6;
                workingDistance = 2.15;
                immersion = this.getImmersion("Air");
                model = "1-UC347";
                break;
            }
            case 10410: {
                lensNA = 1.15;
                immersion = this.getImmersion("Water");
                model = "1-UB769";
                break;
            }
            case 10411: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                model = "1-UC527";
                correction = this.getCorrection("PlanFluor");
                break;
            }
            case 10412: {
                lensNA = 1.34;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("Apo");
                break;
            }
            case 10000: {
                lensNA = 1.3;
                correction = this.getCorrection("Apo");
                immersion = this.getImmersion("Oil");
                model = "1-LB393";
                break;
            }
            case 10001: {
                lensNA = 1.3;
                immersion = this.getImmersion("Oil");
                model = "1-LB392";
                break;
            }
            case 10002: {
                lensNA = 1.4;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                model = "1-UB935";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10003: {
                lensNA = 1.35;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                model = "1-UB836";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10004: {
                lensNA = 1.3;
                immersion = this.getImmersion("Oil");
                model = "1-UB535";
                break;
            }
            case 10005: {
                lensNA = 1.35;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10006: {
                lensNA = 1.4;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10007: {
                lensNA = 1.4;
                workingDistance = 0.13;
                immersion = this.getImmersion("Oil");
                model = "1-U2B836";
                break;
            }
            case 10600: {
                lensNA = 1.4;
                workingDistance = 0.3;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 10601: {
                lensNA = 1.4;
                immersion = this.getImmersion("Oil");
                model = "1-LB751";
                break;
            }
            case 10602: {
                lensNA = 1.4;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                model = "1-UB932";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10603: {
                lensNA = 1.2;
                workingDistance = 0.25;
                immersion = this.getImmersion("Water");
                model = "1-UB891";
                break;
            }
            case 10604: {
                lensNA = 1.2;
                workingDistance = 0.25;
                immersion = this.getImmersion("Water");
                break;
            }
            case 10605: {
                lensNA = 0.7;
                workingDistance = 1.1;
                immersion = this.getImmersion("Air");
                model = "1-UB351";
                break;
            }
            case 10606: {
                lensNA = 0.7;
                workingDistance = 1.1;
                immersion = this.getImmersion("Air");
                model = "1-UC351";
                break;
            }
            case 10607: {
                lensNA = 1.4;
                immersion = this.getImmersion("Oil");
                model = "1-UC932";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10608: {
                lensNA = 1.25;
                immersion = this.getImmersion("Oil");
                model = "1-UB532";
                break;
            }
            case 10609: {
                lensNA = 1.4;
                workingDistance = 0.15;
                immersion = this.getImmersion("Oil");
                model = "1-UB933";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10610: {
                lensNA = 1.4;
                workingDistance = 0.15;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10611: {
                lensNA = 1.2;
                workingDistance = 0.25;
                immersion = this.getImmersion("Water");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 10612: {
                lensNA = 1.42;
                workingDistance = 0.15;
                immersion = this.getImmersion("Oil");
                model = "1-U2B933";
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 12201: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanFluor");
                model = "93146";
                break;
            }
            case 12203: {
                lensNA = 0.45;
                workingDistance = 8.1;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanFluor");
                model = "93150";
                break;
            }
            case 12204: {
                lensNA = 0.45;
                workingDistance = 4.5;
                immersion = this.getImmersion("Air");
                model = "MUE01200/92777";
                break;
            }
            case 12205: {
                lensNA = 0.5;
                workingDistance = 2.1;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanFluor");
                model = "MRH00200/93135";
                break;
            }
            case 12401: {
                lensNA = 1.3;
                workingDistance = 0.16;
                immersion = this.getImmersion("Oil");
                model = "85028";
                break;
            }
            case 12402: {
                lensNA = 1.3;
                workingDistance = 0.22;
                immersion = this.getImmersion("Oil");
                model = "85004";
                break;
            }
            case 12403: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                model = "140508";
                break;
            }
            case 12404: {
                lensNA = 1.3;
                workingDistance = 0.22;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 12405: {
                lensNA = 0.95;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "93105";
                break;
            }
            case 12406: {
                lensNA = 1.0;
                workingDistance = 0.16;
                immersion = this.getImmersion("Oil");
                model = "93106";
                break;
            }
            case 12600: {
                lensNA = 1.4;
                workingDistance = 0.17;
                immersion = this.getImmersion("Oil");
                model = "85020";
                break;
            }
            case 12601: {
                lensNA = 1.4;
                workingDistance = 0.21;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "93108";
                break;
            }
            case 12602: {
                lensNA = 1.2;
                workingDistance = 0.22;
                immersion = this.getImmersion("Water");
                correction = this.getCorrection("PlanApo");
                model = "93109";
                break;
            }
            case 12000: {
                lensNA = 1.4;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "85025";
                break;
            }
            case 12001: {
                lensNA = 1.3;
                workingDistance = 0.14;
                immersion = this.getImmersion("Oil");
                model = "85005";
                break;
            }
            case 12002: {
                lensNA = 1.3;
                workingDistance = 0.14;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("UV");
                model = "85005";
                break;
            }
            case 12003: {
                lensNA = 1.4;
                workingDistance = 0.13;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "93110";
                break;
            }
            case 12004: {
                lensNA = 1.3;
                workingDistance = 0.2;
                immersion = this.getImmersion("Oil");
                model = "93129";
                break;
            }
            case 12101: {
                lensNA = 0.1;
                calibratedMagnification = 2.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "202294";
                break;
            }
            case 12102: {
                lensNA = 0.2;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "108388";
                break;
            }
            case 12103: {
                lensNA = 0.2;
                calibratedMagnification = 4.0;
                workingDistance = 15.7;
                correction = this.getCorrection("PlanApo");
                immersion = this.getImmersion("Air");
                model = "93102";
                break;
            }
            case 12104: {
                lensNA = 0.45;
                workingDistance = 4.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "93103";
                break;
            }
            case 12105: {
                lensNA = 0.3;
                workingDistance = 16.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanFluor");
                model = "93134";
                break;
            }
            case 12106: {
                lensNA = 0.5;
                workingDistance = 1.2;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("SuperFluor");
                model = "93126";
                break;
            }
            case 12107: {
                lensNA = 0.25;
                workingDistance = 10.5;
                immersion = this.getImmersion("Air");
                model = "93183";
                break;
            }
            case 12108: {
                lensNA = 0.25;
                workingDistance = 6.1;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("Achromat");
                model = "93161";
                break;
            }
            case 14001: {
                lensNA = 1.4;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "44 07 08 (02)";
                break;
            }
            case 14002: {
                lensNA = 1.3;
                workingDistance = 0.1;
                immersion = this.getImmersion("Oil");
                model = "44 07 86";
                break;
            }
            case 14003: {
                lensNA = 1.4;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "44 07 80 (02)";
                break;
            }
            case 14004: {
                lensNA = 1.3;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "46 19 46 - 9903";
                break;
            }
            case 14005: {
                lensNA = 1.4;
                immersion = this.getImmersion("Oil");
                model = "44 07 86 (02)";
                break;
            }
            case 14006: {
                lensNA = 1.3;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 14601: {
                lensNA = 1.4;
                calibratedMagnification = 63.0;
                workingDistance = 0.09;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "44 07 60 (03)";
                break;
            }
            case 14602: {
                lensNA = 1.4;
                calibratedMagnification = 63.0;
                workingDistance = 0.09;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "44 07 62 (02)";
                break;
            }
            case 14603: {
                lensNA = 0.9;
                calibratedMagnification = 63.0;
                immersion = this.getImmersion("Water");
                model = "44 00 69";
                break;
            }
            case 14604: {
                lensNA = 1.2;
                workingDistance = 0.09;
                calibratedMagnification = 63.0;
                immersion = this.getImmersion("Water");
                model = "44 06 68";
                break;
            }
            case 14401: {
                lensNA = 1.3;
                workingDistance = 0.14;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("Fluar");
                model = "44 02 55 (01)";
                break;
            }
            case 14402: {
                lensNA = 1.0;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                model = "44 07 51";
                break;
            }
            case 14403: {
                lensNA = 1.2;
                immersion = this.getImmersion("Water");
                correction = this.getCorrection("Apo");
                model = "44 00 52";
                break;
            }
            case 14404: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanNeofluar");
                model = "44 03 51";
                break;
            }
            case 14405: {
                lensNA = 1.3;
                workingDistance = 0.15;
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanNeofluar");
                model = "44 04 50";
                break;
            }
            case 14406: {
                lensNA = 0.6;
                immersion = this.getImmersion("Air");
                model = "44 08 65";
                break;
            }
            case 14407: {
                lensNA = 1.3;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanNeofluar");
                break;
            }
            case 14301: {
                lensNA = 0.8;
                calibratedMagnification = 25.0;
                workingDistance = 0.8;
                correction = this.getCorrection("PlanNeofluar");
                model = "44 05 44";
                break;
            }
            case 14302: {
                lensNA = 0.8;
                workingDistance = 0.8;
                calibratedMagnification = 25.0;
                correction = this.getCorrection("PlanNeofluar");
                model = "44 05 42";
                break;
            }
            case 14303: {
                lensNA = 0.8;
                calibratedMagnification = 25.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanNeofluar");
                model = "44 05 45";
                break;
            }
            case 14201: {
                lensNA = 0.5;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanNeofluar");
                model = "44 03 41 (01)";
                break;
            }
            case 14202: {
                lensNA = 0.6;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "44 06 40";
                break;
            }
            case 14203: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "44 06 49";
                break;
            }
            case 14204: {
                lensNA = 0.75;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("Fluar");
                model = "44 01 45";
                break;
            }
            case 14101: {
                lensNA = 0.3;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanNeofluar");
                model = "44 03 30";
                break;
            }
            case 14102: {
                lensNA = 0.25;
                immersion = this.getImmersion("Air");
                model = "44 01 31";
                break;
            }
            case 14103: {
                lensNA = 0.25;
                immersion = this.getImmersion("Air");
                model = "44 00 31";
                break;
            }
            case 14104: {
                lensNA = 0.45;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "44 06 39";
                break;
            }
            case 14105: {
                lensNA = 0.16;
                calibratedMagnification = 5.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                model = "44 06 20";
                break;
            }
            case 18101: {
                lensNA = 0.2;
                workingDistance = 3.33;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 18102: {
                lensNA = 0.2;
                workingDistance = 2.883;
                calibratedMagnification = 2.46;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 18103: {
                lensNA = 0.2;
                workingDistance = 2.883;
                calibratedMagnification = 4.0;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 18104: {
                lensNA = 0.45;
                calibratedMagnification = 6.15;
                workingDistance = 2.883;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 18105: {
                lensNA = 0.45;
                workingDistance = 2.883;
                immersion = this.getImmersion("Air");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 18106: {
                lensNA = 0.1;
                workingDistance = 24.0;
                calibratedMagnification = 1.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 18201: {
                lensNA = 0.55;
                workingDistance = 13.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 18202: {
                lensNA = 0.5;
                workingDistance = 13.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 18204: {
                lensNA = 0.45;
                workingDistance = 4.5;
                immersion = this.getImmersion("Air");
                model = "MUE01200/92777";
                break;
            }
            case 18205: {
                lensNA = 0.5;
                workingDistance = 2.1;
                immersion = this.getImmersion("Air");
                model = "MRH00200/93135";
                break;
            }
            case 1: {
                lensNA = 0.25;
                manufacturer = "Zeiss";
                calibratedMagnification = 10.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 2: {
                lensNA = 0.5;
                manufacturer = "Zeiss";
                calibratedMagnification = 25.0;
                immersion = this.getImmersion("Air");
                break;
            }
            case 3: {
                lensNA = 1.0;
                manufacturer = "Zeiss";
                calibratedMagnification = 50.0;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 4: {
                lensNA = 1.25;
                manufacturer = "Zeiss";
                calibratedMagnification = 63.0;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 5: {
                lensNA = 1.3;
                manufacturer = "Zeiss";
                calibratedMagnification = 100.0;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 6: {
                lensNA = 1.3;
                calibratedMagnification = 100.0;
                correction = this.getCorrection("Neofluor");
                immersion = this.getImmersion("Oil");
                break;
            }
            case 7: {
                lensNA = 1.4;
                calibratedMagnification = 63.0;
                manufacturer = "Leitz";
                immersion = this.getImmersion("Oil");
                correction = this.getCorrection("PlanApo");
                break;
            }
            case 8: {
                lensNA = 1.2;
                calibratedMagnification = 63.0;
                immersion = this.getImmersion("Water");
                break;
            }
            case 9: {
                lensNA = 0.4;
                workingDistance = 0.3;
                calibratedMagnification = 10.0;
                manufacturer = "Olympus";
                immersion = this.getImmersion("Air");
                break;
            }
            case 10: {
                lensNA = 0.8;
                workingDistance = 0.3;
                manufacturer = "Olympus";
                calibratedMagnification = 20.0;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 11: {
                lensNA = 1.3;
                calibratedMagnification = 40.0;
                manufacturer = "Olympus";
                workingDistance = 0.3;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 12: {
                lensNA = 1.4;
                workingDistance = 0.3;
                manufacturer = "Olympus";
                calibratedMagnification = 60.0;
                immersion = this.getImmersion("Oil");
                break;
            }
            case 13: {
                lensNA = 1.4;
                workingDistance = 0.3;
                manufacturer = "Nikon";
                calibratedMagnification = 100.0;
                immersion = this.getImmersion("Oil");
            }
        }
        String objectiveID = "Objective:" + lensID;
        store.setObjectiveID(objectiveID, 0, 0);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            store.setObjectiveSettingsID(objectiveID, series);
        }
        store.setObjectiveLensNA(lensNA, 0, 0);
        store.setObjectiveImmersion(immersion, 0, 0);
        store.setObjectiveCorrection(correction, 0, 0);
        store.setObjectiveManufacturer(manufacturer, 0, 0);
        store.setObjectiveModel(model, 0, 0);
        if (magnification > 0) {
            store.setObjectiveNominalMagnification(new PositiveInteger(magnification), 0, 0);
        } else {
            LOGGER.warn("Expected positive value for NominalMagnification; got {}", magnification);
        }
        if (calibratedMagnification != null) {
            store.setObjectiveCalibratedMagnification(calibratedMagnification, 0, 0);
        }
        if (workingDistance != null) {
            store.setObjectiveWorkingDistance(workingDistance * 1000.0, 0, 0);
        }
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        public float photosensorReading;
        public float timeStampSeconds;
        public float stageXCoord;
        public float stageYCoord;
        public float stageZCoord;
        public float minInten;
        public float maxInten;
        public float expTime;
        public float ndFilter;
        public float exWavelen;
        public float emWavelen;
        public float intenScaling;
        public float energyConvFactor;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        private DVExtHdrFields(RandomAccessInputStream in) {
            try {
                this.photosensorReading = in.readFloat();
                this.timeStampSeconds = in.readFloat();
                this.stageXCoord = in.readFloat();
                this.stageYCoord = in.readFloat();
                this.stageZCoord = in.readFloat();
                this.minInten = in.readFloat();
                this.maxInten = in.readFloat();
                in.skipBytes(4);
                this.expTime = in.readFloat() / 1000.0f;
                this.ndFilter = in.readFloat() / 100.0f;
                this.exWavelen = in.readFloat();
                this.emWavelen = in.readFloat();
                this.intenScaling = in.readFloat();
                this.energyConvFactor = in.readFloat();
            }
            catch (IOException e) {
                LOGGER.debug("Could not parse extended header", e);
            }
        }
    }
}

