/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class RotatedPole
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "rotated_latitude_longitude";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon = this.readAttributeDouble(ctv, "grid_north_pole_longitude");
        double lat = this.readAttributeDouble(ctv, "grid_north_pole_latitude");
        ucar.unidata.geoloc.projection.RotatedPole proj = new ucar.unidata.geoloc.projection.RotatedPole(lat, lon);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

