/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.image.input.ImgReaderPGM;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.roi.encoder.ArbROIMaskGenerator;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.roi.encoder.RectROIMaskGenerator;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ROIScaler
extends ImgDataAdapter
implements CBlkQuantDataSrcEnc {
    public static final char OPT_PREFIX = 'R';
    private static final String[][] pinfo = new String[][]{{"Rroi", "[<component idx>] R <left> <top> <width> <height> or [<component idx>] C <centre column> <centre row> <radius> or [<component idx>] A <filename>", "Specifies ROIs shape and location. The shape can be either rectangular 'R', or circular 'C' or arbitrary 'A'. Each new occurrence of an 'R', a 'C' or an 'A' is a new ROI. For circular and rectangular ROIs, all values are given as their pixel values relative to the canvas origin. Arbitrary shapes must be included in a PGM file where non 0 values correspond to ROI coefficients. The PGM file must have the size as the image. The component idx specifies which components contain the ROI. The component index is specified as described by points 3 and 4 in the general comment on tile-component idx. If this option is used, the codestream is layer progressive by default unless it is overridden by the 'Aptype' option.", null}, {"Ralign", "[true|false]", "By specifying this argument, the ROI mask will be limited to covering only entire code-blocks. The ROI coding can then be performed without any actual scaling of the coefficients but by instead scaling the distortion estimates.", "false"}, {"Rstart_level", "<level>", "This argument forces the lowest <level> resolution levels to belong to the ROI. By doing this, it is possible to avoid only getting information for the ROI at an early stage of transmission.<level> = 0 means the lowest resolution level belongs to the ROI, 1 means the two lowest etc. (-1 deactivates the option)", "-1"}, {"Rno_rect", "[true|false]", "This argument makes sure that the ROI mask generation is not done using the fast ROI mask generation for rectangular ROIs regardless of whether the specified ROIs are rectangular or not", "false"}};
    private int[][] maxMagBits;
    private boolean roi;
    private boolean blockAligned;
    private int useStartLevel;
    private ROIMaskGenerator mg;
    private DataBlkInt roiMask;
    private Quantizer src;

    public ROIScaler(Quantizer src, ROIMaskGenerator mg, boolean roi, int sLev, boolean uba, J2KImageWriteParamJava wp) {
        super(src);
        this.src = src;
        this.roi = roi;
        this.useStartLevel = sLev;
        if (roi) {
            this.mg = mg;
            this.roiMask = new DataBlkInt();
            this.calcMaxMagBits(wp);
            this.blockAligned = uba;
        }
    }

    public boolean isReversible(int t, int c) {
        return this.src.isReversible(t, c);
    }

    public SubbandAn getAnSubbandTree(int t, int c) {
        return this.src.getAnSubbandTree(t, c);
    }

    public int getCbULX() {
        return this.src.getCbULX();
    }

    public int getCbULY() {
        return this.src.getCbULY();
    }

    public static ROIScaler createInstance(Quantizer src, J2KImageWriteParamJava wp) {
        Vector roiVector = new Vector();
        ROIMaskGenerator maskGen = null;
        String roiopt = wp.getROIs().getSpecified();
        if (roiopt == null) {
            return new ROIScaler(src, null, false, -1, false, wp);
        }
        int sLev = wp.getStartLevelROI();
        boolean useBlockAligned = wp.getAlignROI();
        boolean onlyRect = false;
        ROIScaler.parseROIs(roiopt, src.getNumComps(), roiVector);
        Object[] roiArray = new ROI[roiVector.size()];
        roiVector.copyInto(roiArray);
        if (onlyRect) {
            for (int i = roiArray.length - 1; i >= 0; --i) {
                if (((ROI)roiArray[i]).rect) continue;
                onlyRect = false;
                break;
            }
        }
        maskGen = onlyRect ? new RectROIMaskGenerator((ROI[])roiArray, src.getNumComps()) : new ArbROIMaskGenerator((ROI[])roiArray, src.getNumComps(), src);
        return new ROIScaler(src, maskGen, true, sLev, useBlockAligned, wp);
    }

    protected static Vector parseROIs(String roiopt, int nc, Vector roiVector) {
        int nrOfROIs = 0;
        boolean[] roiInComp = null;
        StringTokenizer stok = new StringTokenizer(roiopt);
        block16: while (stok.hasMoreTokens()) {
            String word = stok.nextToken();
            switch (word.charAt(0)) {
                case 'c': {
                    roiInComp = ModuleSpec.parseIdx(word, nc);
                    break;
                }
                case 'R': {
                    ROI roi;
                    int i;
                    int h;
                    int w;
                    int uly;
                    int ulx;
                    ++nrOfROIs;
                    try {
                        word = stok.nextToken();
                        ulx = new Integer(word);
                        word = stok.nextToken();
                        uly = new Integer(word);
                        word = stok.nextToken();
                        w = new Integer(word);
                        word = stok.nextToken();
                        h = new Integer(word);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad parameter for '-Rroi R' option : " + word);
                    }
                    catch (NoSuchElementException f) {
                        throw new IllegalArgumentException("Wrong number of parameters for  h'-Rroi R' option.");
                    }
                    if (roiInComp != null) {
                        for (i = 0; i < nc; ++i) {
                            if (!roiInComp[i]) continue;
                            roi = new ROI(i, ulx, uly, w, h);
                            roiVector.addElement(roi);
                        }
                        continue block16;
                    }
                    for (i = 0; i < nc; ++i) {
                        roi = new ROI(i, ulx, uly, w, h);
                        roiVector.addElement(roi);
                    }
                    continue block16;
                }
                case 'C': {
                    int rad;
                    int y;
                    int x;
                    ROI roi;
                    int i;
                    ++nrOfROIs;
                    try {
                        word = stok.nextToken();
                        x = new Integer(word);
                        word = stok.nextToken();
                        y = new Integer(word);
                        word = stok.nextToken();
                        rad = new Integer(word);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad parameter for '-Rroi C' option : " + word);
                    }
                    catch (NoSuchElementException f) {
                        throw new IllegalArgumentException("Wrong number of parameters for '-Rroi C' option.");
                    }
                    if (roiInComp != null) {
                        for (i = 0; i < nc; ++i) {
                            if (!roiInComp[i]) continue;
                            roi = new ROI(i, x, y, rad);
                            roiVector.addElement(roi);
                        }
                        continue block16;
                    }
                    for (i = 0; i < nc; ++i) {
                        roi = new ROI(i, x, y, rad);
                        roiVector.addElement(roi);
                    }
                    continue block16;
                }
                case 'A': {
                    int i;
                    String filename;
                    ROI roi;
                    ++nrOfROIs;
                    ImgReaderPGM maskPGM = null;
                    try {
                        filename = stok.nextToken();
                    }
                    catch (NoSuchElementException e) {
                        throw new IllegalArgumentException("Wrong number of parameters for '-Rroi A' option.");
                    }
                    try {
                        maskPGM = new ImgReaderPGM(filename);
                    }
                    catch (IOException e) {
                        throw new Error("Cannot read PGM file with ROI");
                    }
                    if (roiInComp != null) {
                        for (i = 0; i < nc; ++i) {
                            if (!roiInComp[i]) continue;
                            roi = new ROI(i, maskPGM);
                            roiVector.addElement(roi);
                        }
                        continue block16;
                    }
                    for (i = 0; i < nc; ++i) {
                        roi = new ROI(i, maskPGM);
                        roiVector.addElement(roi);
                    }
                    continue block16;
                }
                default: {
                    throw new Error("Bad parameters for ROI nr " + roiVector.size());
                }
            }
        }
        return roiVector;
    }

    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cblk) {
        return this.getNextInternCodeBlock(n, cblk);
    }

    public CBlkWTData getNextInternCodeBlock(int c, CBlkWTData cblk) {
        int i;
        DataBlkInt mask = this.roiMask;
        int bitMask = Integer.MAX_VALUE;
        int maxBits = 0;
        int nROIcoeff = 0;
        cblk = this.src.getNextCodeBlock(c, cblk);
        if (!this.roi || cblk == null) {
            return cblk;
        }
        int[] data = (int[])cblk.getData();
        SubbandAn sb = cblk.sb;
        int ulx = cblk.ulx;
        int uly = cblk.uly;
        int w = cblk.w;
        int h = cblk.h;
        boolean sbInMask = sb.resLvl <= this.useStartLevel;
        int[] maskData = mask.getDataInt();
        if (maskData == null || w * h > maskData.length) {
            maskData = new int[w * h];
            mask.setDataInt(maskData);
        } else {
            for (i = w * h - 1; i >= 0; --i) {
                maskData[i] = 0;
            }
        }
        mask.ulx = ulx;
        mask.uly = uly;
        mask.w = w;
        mask.h = h;
        SubbandAn root = this.src.getAnSubbandTree(this.tIdx, c);
        maxBits = this.maxMagBits[this.tIdx][c];
        boolean roiInTile = this.mg.getROIMask(mask, root, maxBits, c);
        if (!roiInTile && !sbInMask) {
            cblk.nROIbp = 0;
            return cblk;
        }
        cblk.nROIbp = cblk.magbits;
        if (sbInMask) {
            cblk.wmseScaling *= (float)(1 << (maxBits << 1));
            cblk.nROIcoeff = w * h;
            return cblk;
        }
        if (this.blockAligned) {
            int wrap = cblk.scanw - w;
            int mi = h * w - 1;
            i = cblk.offset + cblk.scanw * (h - 1) + w - 1;
            int nroicoeff = 0;
            for (int j = h; j > 0; --j) {
                int k = w - 1;
                while (k >= 0) {
                    if (maskData[mi] != 0) {
                        ++nroicoeff;
                    }
                    --k;
                    --i;
                    --mi;
                }
                i -= wrap;
            }
            if (nroicoeff != 0) {
                cblk.wmseScaling *= (float)(1 << (maxBits << 1));
                cblk.nROIcoeff = w * h;
            }
            return cblk;
        }
        bitMask = (1 << cblk.magbits) - 1 << 31 - cblk.magbits;
        int wrap = cblk.scanw - w;
        int mi = h * w - 1;
        i = cblk.offset + cblk.scanw * (h - 1) + w - 1;
        for (int j = h; j > 0; --j) {
            int k = w;
            while (k > 0) {
                int tmp = data[i];
                if (maskData[mi] != 0) {
                    data[i] = Integer.MIN_VALUE & tmp | tmp & bitMask;
                    ++nROIcoeff;
                } else {
                    data[i] = Integer.MIN_VALUE & tmp | (tmp & Integer.MAX_VALUE) >> maxBits;
                }
                --k;
                --i;
                --mi;
            }
            i -= wrap;
        }
        cblk.magbits += maxBits;
        cblk.nROIcoeff = nROIcoeff;
        return cblk;
    }

    public ROIMaskGenerator getROIMaskGenerator() {
        return this.mg;
    }

    public boolean getBlockAligned() {
        return this.blockAligned;
    }

    public boolean useRoi() {
        return this.roi;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public void setTile(int x, int y) {
        super.setTile(x, y);
        if (this.roi) {
            this.mg.tileChanged();
        }
    }

    public void nextTile() {
        super.nextTile();
        if (this.roi) {
            this.mg.tileChanged();
        }
    }

    private void calcMaxMagBits(J2KImageWriteParamJava wp) {
        MaxShiftSpec rois = wp.getROIs();
        int nt = this.src.getNumTiles();
        int nc = this.src.getNumComps();
        this.maxMagBits = new int[nt][nc];
        this.src.setTile(0, 0);
        for (int t = 0; t < nt; ++t) {
            for (int c = nc - 1; c >= 0; --c) {
                int tmp;
                this.maxMagBits[t][c] = tmp = this.src.getMaxMagBits(c);
                rois.setTileCompVal(t, c, new Integer(tmp));
            }
            if (t >= nt - 1) continue;
            this.src.nextTile();
        }
        this.src.setTile(0, 0);
    }
}

