/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import loci.formats.gui.XMLCellRenderer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLWindow
extends JFrame {
    private Document doc;

    public XMLWindow() {
    }

    public XMLWindow(String title) {
        super(title);
    }

    public void setXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        this.setDocument(null);
        DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = docFact.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document doc = db.parse(is);
        is.close();
        this.setDocument(doc);
    }

    public void setXML(File file2) throws ParserConfigurationException, SAXException, IOException {
        this.setDocument(null);
        DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = docFact.newDocumentBuilder();
        Document doc = db.parse(file2);
        this.setDocument(doc);
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.getContentPane().removeAll();
        if (doc == null) {
            this.setVisible(false);
        } else {
            JTree tree = XMLCellRenderer.makeJTree(doc);
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
            this.getContentPane().add(new JScrollPane(tree));
            this.pack();
            Dimension dim = this.getSize();
            int pad = 20;
            dim.width += 20;
            dim.height += 20;
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            int maxWidth = 3 * ss.width / 4;
            int maxHeight = 3 * ss.height / 4;
            if (dim.width > maxWidth) {
                dim.width = maxWidth;
            }
            if (dim.height > maxHeight) {
                dim.height = maxHeight;
            }
            this.setSize(dim);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public static void main(String[] args) throws Exception {
        XMLWindow xmlWindow = new XMLWindow();
        xmlWindow.setDefaultCloseOperation(3);
        if (args.length > 0) {
            String filename = args[0];
            xmlWindow.setXML(new File(filename));
            xmlWindow.setTitle("XML Window - " + filename);
        } else {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            xmlWindow.setXML(sb.toString());
            xmlWindow.setTitle("XML Window - <stdin>");
        }
        xmlWindow.setLocation(200, 200);
        xmlWindow.setVisible(true);
    }
}

