/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.filesystem;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.poi.poifs.dev.POIFSViewable;
import loci.poi.poifs.filesystem.BATManaged;
import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.DirectoryNode;
import loci.poi.poifs.filesystem.DocumentEntry;
import loci.poi.poifs.filesystem.DocumentInputStream;
import loci.poi.poifs.filesystem.DocumentNode;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.poifs.filesystem.EntryNode;
import loci.poi.poifs.filesystem.POIFSDocument;
import loci.poi.poifs.filesystem.POIFSWriterListener;
import loci.poi.poifs.property.DirectoryProperty;
import loci.poi.poifs.property.Property;
import loci.poi.poifs.property.PropertyTable;
import loci.poi.poifs.storage.BATBlock;
import loci.poi.poifs.storage.BlockAllocationTableReader;
import loci.poi.poifs.storage.BlockAllocationTableWriter;
import loci.poi.poifs.storage.BlockList;
import loci.poi.poifs.storage.BlockWritable;
import loci.poi.poifs.storage.HeaderBlockReader;
import loci.poi.poifs.storage.HeaderBlockWriter;
import loci.poi.poifs.storage.RawDataBlockList;
import loci.poi.poifs.storage.SmallBlockTableReader;
import loci.poi.poifs.storage.SmallBlockTableWriter;

public class POIFSFileSystem
implements POIFSViewable {
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;
    private int bigBlockSize;
    private RandomAccessInputStream stream;

    public POIFSFileSystem() {
    }

    public POIFSFileSystem(RandomAccessInputStream stream, int size) throws IOException {
        this();
        this.stream = stream;
        HeaderBlockReader header_block_reader = new HeaderBlockReader(stream, size);
        RawDataBlockList data_blocks = new RawDataBlockList(stream, size);
        new BlockAllocationTableReader(header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), data_blocks, size);
        PropertyTable properties = new PropertyTable(header_block_reader.getPropertyStart(), data_blocks);
        BlockList small = SmallBlockTableReader.getSmallDocumentBlocks(data_blocks, properties.getRoot(), header_block_reader.getSBATStart());
        this.processProperties(small, data_blocks, properties.getRoot().getChildren(), null);
    }

    public DocumentEntry createDocument(RandomAccessInputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter sbtw = new SmallBlockTableWriter(this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter bat = new BlockAllocationTableWriter();
        ArrayList<BATManaged> bm_objects = new ArrayList<BATManaged>();
        bm_objects.addAll(this._documents);
        bm_objects.add(this._property_table);
        bm_objects.add(sbtw);
        bm_objects.add(sbtw.getSBAT());
        Iterator iter = bm_objects.iterator();
        while (iter.hasNext()) {
            BATManaged bmo = (BATManaged)iter.next();
            int block_count = bmo.countBlocks();
            if (block_count == 0) continue;
            bmo.setStartBlock(bat.allocateSpace(block_count));
        }
        int batStartBlock = bat.createBlocks(512);
        HeaderBlockWriter header_block_writer = new HeaderBlockWriter(512);
        BATBlock[] xbat_blocks = header_block_writer.setBATBlocks(bat.countBlocks(), batStartBlock, 512);
        header_block_writer.setPropertyStart(this._property_table.getStartBlock());
        header_block_writer.setSBATStart(sbtw.getSBAT().getStartBlock());
        header_block_writer.setSBATBlockCount(sbtw.getSBATBlockCount());
        ArrayList<BlockWritable> writers = new ArrayList<BlockWritable>();
        writers.add(header_block_writer);
        writers.addAll(this._documents);
        writers.add(this._property_table);
        writers.add(sbtw);
        writers.add(sbtw.getSBAT());
        writers.add(bat);
        for (int j = 0; j < xbat_blocks.length; ++j) {
            writers.add(xbat_blocks[j]);
        }
        iter = writers.iterator();
        while (iter.hasNext()) {
            BlockWritable writer = (BlockWritable)iter.next();
            writer.writeBlocks(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileOutputStream ostream = new FileOutputStream(args[1]);
        RandomAccessInputStream in = new RandomAccessInputStream(args[0]);
        new POIFSFileSystem(in, 512).writeFilesystem(ostream);
        in.close();
        ostream.close();
    }

    public DirectoryEntry getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        Entry document = this.getRoot().getEntry(documentName);
        if (!document.isDocumentEntry()) {
            throw new IOException("Entry '" + documentName + "' is not a DocumentEntry");
        }
        return new DocumentInputStream((DocumentEntry)document, this.stream);
    }

    void addDocument(POIFSDocument document) {
        this._documents.add(document);
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    void remove(EntryNode entry) {
        this._property_table.removeProperty(entry.getProperty());
        if (entry.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entry).getDocument());
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, DirectoryNode dir) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = (Property)properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? (DirectoryNode)this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size = property.getSize();
            POIFSDocument document = null;
            document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock), size, this.bigBlockSize) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock), size, this.bigBlockSize);
            parent.createDocument(document);
        }
    }

    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableArray();
        }
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return ((POIFSViewable)((Object)this.getRoot())).preferArray();
    }

    public String getShortDescription() {
        return "POIFS FileSystem";
    }
}

