/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingConventionEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingConventionEnumHandler.class);
    private static final Hashtable<String, String> patterns = NamingConventionEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*letter\\s*", "letter");
        p.put("^\\s*number\\s*", "number");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return NamingConvention.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"NamingConvention", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return NamingConvention.class;
    }
}

