/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Random;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class FakeReader
extends FormatReader {
    public static final int BOX_SIZE = 10;
    public static final int DEFAULT_SIZE_X = 512;
    public static final int DEFAULT_SIZE_Y = 512;
    public static final int DEFAULT_SIZE_Z = 1;
    public static final int DEFAULT_SIZE_C = 1;
    public static final int DEFAULT_SIZE_T = 1;
    public static final int DEFAULT_PIXEL_TYPE = 1;
    public static final int DEFAULT_RGB_CHANNEL_COUNT = 1;
    public static final String DEFAULT_DIMENSION_ORDER = "XYZCT";
    private static final String TOKEN_SEPARATOR = "&";
    private static final long SEED = -889275714L;
    private double scaleFactor = 1.0;
    private byte[][][] lut8 = null;
    private short[][][] lut16 = null;
    private int[][] indexToValue = null;
    private int[][] valueToIndex = null;
    private int ac = 0;

    public FakeReader() {
        super("Simulated data", "fake");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut8 == null ? (byte[][])null : this.lut8[this.ac];
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut16 == null ? (short[][])null : this.lut16[this.ac];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        long min;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int series = this.getSeries();
        int pixelType = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        boolean signed = FormatTools.isSigned(pixelType);
        boolean floating = FormatTools.isFloatingPoint(pixelType);
        int rgb = this.getRGBChannelCount();
        boolean indexed = this.isIndexed();
        boolean little = this.isLittleEndian();
        boolean interleaved = this.isInterleaved();
        int[] zct = this.getZCTCoords(no);
        int zIndex = zct[0];
        int cIndex = zct[1];
        int tIndex = zct[2];
        this.ac = cIndex;
        long l = min = signed ? (long)(-Math.pow(2.0, 8 * bpp - 1)) : 0L;
        if (floating) {
            min = 0L;
        }
        for (int cOffset = 0; cOffset < rgb; ++cOffset) {
            int channel = rgb * cIndex + cOffset;
            for (int row = 0; row < h; ++row) {
                int yy = y + row;
                for (int col = 0; col < w; ++col) {
                    int xx = x + col;
                    long pixel = min + (long)xx;
                    boolean specialPixel = false;
                    if (yy < 10) {
                        int grid = xx / 10;
                        specialPixel = true;
                        switch (grid) {
                            case 0: {
                                pixel = series;
                                break;
                            }
                            case 1: {
                                pixel = no;
                                break;
                            }
                            case 2: {
                                pixel = zIndex;
                                break;
                            }
                            case 3: {
                                pixel = channel;
                                break;
                            }
                            case 4: {
                                pixel = tIndex;
                                break;
                            }
                            default: {
                                specialPixel = false;
                            }
                        }
                    }
                    if (indexed) {
                        if (this.lut8 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 256L)];
                        }
                        if (this.lut16 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 65536L)];
                        }
                    }
                    switch (pixelType) {
                        case 6: {
                            float floatPixel = specialPixel ? (float)pixel : (float)(this.scaleFactor * (double)pixel);
                            pixel = Float.floatToIntBits(floatPixel);
                            break;
                        }
                        case 7: {
                            double doublePixel = specialPixel ? (double)pixel : this.scaleFactor * (double)pixel;
                            pixel = Double.doubleToLongBits(doublePixel);
                            break;
                        }
                        default: {
                            if (specialPixel) break;
                            pixel = (long)(this.scaleFactor * (double)pixel);
                        }
                    }
                    int index = interleaved ? w * rgb * row + rgb * col + cOffset : h * w * cOffset + w * row + col;
                    DataTools.unpackBytes(pixel, buf, index *= bpp, bpp, little);
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        block45: {
            int i;
            int num;
            int lutLength;
            int pixelType;
            int sizeC;
            block46: {
                super.initFile(id);
                String path = id;
                if (new Location(id).exists()) {
                    path = new Location(id).getAbsoluteFile().getName();
                }
                String noExt = path.substring(0, path.lastIndexOf("."));
                String[] tokens = noExt.split(TOKEN_SEPARATOR);
                String name = null;
                int sizeX = 512;
                int sizeY = 512;
                int sizeZ = 1;
                sizeC = 1;
                int sizeT = 1;
                int thumbSizeX = 0;
                int thumbSizeY = 0;
                pixelType = 1;
                int bitsPerPixel = 0;
                int rgb = 1;
                String dimOrder = DEFAULT_DIMENSION_ORDER;
                boolean orderCertain = true;
                boolean little = true;
                boolean interleaved = false;
                boolean indexed = false;
                boolean falseColor = false;
                boolean metadataComplete = true;
                boolean thumbnail = false;
                int seriesCount = 1;
                lutLength = 3;
                for (String token : tokens) {
                    int intValue;
                    if (name == null) {
                        name = token;
                        continue;
                    }
                    int equals = token.indexOf("=");
                    if (equals < 0) {
                        LOGGER.warn("ignoring token: {}", (Object)token);
                        continue;
                    }
                    String key = token.substring(0, equals);
                    String value = token.substring(equals + 1);
                    boolean boolValue = value.equals("true");
                    double doubleValue = Double.NaN;
                    try {
                        doubleValue = Double.parseDouble(value);
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                    int n = intValue = Double.isNaN(doubleValue) ? -1 : (int)doubleValue;
                    if (key.equals("sizeX")) {
                        sizeX = intValue;
                        continue;
                    }
                    if (key.equals("sizeY")) {
                        sizeY = intValue;
                        continue;
                    }
                    if (key.equals("sizeZ")) {
                        sizeZ = intValue;
                        continue;
                    }
                    if (key.equals("sizeC")) {
                        sizeC = intValue;
                        continue;
                    }
                    if (key.equals("sizeT")) {
                        sizeT = intValue;
                        continue;
                    }
                    if (key.equals("thumbSizeX")) {
                        thumbSizeX = intValue;
                        continue;
                    }
                    if (key.equals("thumbSizeY")) {
                        thumbSizeY = intValue;
                        continue;
                    }
                    if (key.equals("pixelType")) {
                        pixelType = FormatTools.pixelTypeFromString(value);
                        continue;
                    }
                    if (key.equals("bitsPerPixel")) {
                        bitsPerPixel = intValue;
                        continue;
                    }
                    if (key.equals("rgb")) {
                        rgb = intValue;
                        continue;
                    }
                    if (key.equals("dimOrder")) {
                        dimOrder = value.toUpperCase();
                        continue;
                    }
                    if (key.equals("orderCertain")) {
                        orderCertain = boolValue;
                        continue;
                    }
                    if (key.equals("little")) {
                        little = boolValue;
                        continue;
                    }
                    if (key.equals("interleaved")) {
                        interleaved = boolValue;
                        continue;
                    }
                    if (key.equals("indexed")) {
                        indexed = boolValue;
                        continue;
                    }
                    if (key.equals("falseColor")) {
                        falseColor = boolValue;
                        continue;
                    }
                    if (key.equals("metadataComplete")) {
                        metadataComplete = boolValue;
                        continue;
                    }
                    if (key.equals("thumbnail")) {
                        thumbnail = boolValue;
                        continue;
                    }
                    if (key.equals("series")) {
                        seriesCount = intValue;
                        continue;
                    }
                    if (key.equals("lutLength")) {
                        lutLength = intValue;
                        continue;
                    }
                    if (!key.equals("scaleFactor")) continue;
                    this.scaleFactor = doubleValue;
                }
                if (sizeX < 1) {
                    throw new FormatException("Invalid sizeX: " + sizeX);
                }
                if (sizeY < 1) {
                    throw new FormatException("Invalid sizeY: " + sizeY);
                }
                if (sizeZ < 1) {
                    throw new FormatException("Invalid sizeZ: " + sizeZ);
                }
                if (sizeC < 1) {
                    throw new FormatException("Invalid sizeC: " + sizeC);
                }
                if (sizeT < 1) {
                    throw new FormatException("Invalid sizeT: " + sizeT);
                }
                if (thumbSizeX < 0) {
                    throw new FormatException("Invalid thumbSizeX: " + thumbSizeX);
                }
                if (thumbSizeY < 0) {
                    throw new FormatException("Invalid thumbSizeY: " + thumbSizeY);
                }
                if (rgb < 1 || rgb > sizeC || sizeC % rgb != 0) {
                    throw new FormatException("Invalid sizeC/rgb combination: " + sizeC + "/" + rgb);
                }
                this.getDimensionOrder(dimOrder);
                if (falseColor && !indexed) {
                    throw new FormatException("False color images must be indexed");
                }
                if (seriesCount < 1) {
                    throw new FormatException("Invalid seriesCount: " + seriesCount);
                }
                if (lutLength < 1) {
                    throw new FormatException("Invalid lutLength: " + lutLength);
                }
                int effSizeC = sizeC / rgb;
                this.core = new CoreMetadata[seriesCount];
                for (int s = 0; s < seriesCount; ++s) {
                    this.core[s] = new CoreMetadata();
                    this.core[s].sizeX = sizeX;
                    this.core[s].sizeY = sizeY;
                    this.core[s].sizeZ = sizeZ;
                    this.core[s].sizeC = sizeC;
                    this.core[s].sizeT = sizeT;
                    this.core[s].thumbSizeX = thumbSizeX;
                    this.core[s].thumbSizeY = thumbSizeY;
                    this.core[s].pixelType = pixelType;
                    this.core[s].bitsPerPixel = bitsPerPixel;
                    this.core[s].imageCount = sizeZ * effSizeC * sizeT;
                    this.core[s].rgb = rgb > 1;
                    this.core[s].dimensionOrder = dimOrder;
                    this.core[s].orderCertain = orderCertain;
                    this.core[s].littleEndian = little;
                    this.core[s].interleaved = interleaved;
                    this.core[s].indexed = indexed;
                    this.core[s].falseColor = falseColor;
                    this.core[s].metadataComplete = metadataComplete;
                    this.core[s].thumbnail = thumbnail;
                }
                MetadataStore store = this.makeFilterMetadata();
                MetadataTools.populatePixels(store, this);
                for (int s = 0; s < seriesCount; ++s) {
                    String imageName = s > 0 ? name + " " + (s + 1) : name;
                    store.setImageName(imageName, s);
                }
                if (!indexed) break block45;
                if (pixelType != true) break block46;
                num = 256;
                this.createIndexMap(256);
                this.lut8 = new byte[sizeC][lutLength][256];
                for (int c = 0; c < sizeC; ++c) {
                    for (i = 0; i < lutLength; ++i) {
                        for (int index = 0; index < 256; ++index) {
                            this.lut8[c][i][index] = (byte)this.indexToValue[c][index];
                        }
                    }
                }
                break block45;
            }
            if (pixelType != 3) break block45;
            num = 65536;
            this.createIndexMap(65536);
            this.lut16 = new short[sizeC][lutLength][65536];
            for (int c = 0; c < sizeC; ++c) {
                for (i = 0; i < lutLength; ++i) {
                    for (int index = 0; index < 65536; ++index) {
                        this.lut16[c][i][index] = (short)this.indexToValue[c][index];
                    }
                }
            }
        }
    }

    private void createIndexMap(int num) {
        int index;
        int c;
        int sizeC = this.core[0].sizeC;
        this.indexToValue = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            for (index = 0; index < num; ++index) {
                this.indexToValue[c][index] = index;
            }
            FakeReader.shuffle(c, this.indexToValue[c]);
        }
        this.valueToIndex = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            index = 0;
            while (index < num) {
                int value = this.indexToValue[c][index];
                this.valueToIndex[c][value] = index++;
            }
        }
    }

    private static void shuffle(int c, int[] array) {
        Random r = new Random(-889275714L + (long)c);
        for (int i = array.length; i > 1; --i) {
            int j = r.nextInt(i);
            int tmp = array[j];
            array[j] = array[i - 1];
            array[i - 1] = tmp;
        }
    }
}

