/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;
import ucar.unidata.util.SpecialMathFunction;

public class Mercator
extends ProjectionImpl {
    private double lat0;
    private double lon0;
    private double par;
    private double lat0_r;
    private double lon0_r;
    private double par_r;
    private double A;
    private double y0;
    private LatLonPointImpl origin;

    public ProjectionImpl constructCopy() {
        return new Mercator(this.getOriginLat(), this.getOriginLon(), this.getParallel());
    }

    public Mercator() {
        this(40.0, -105.0, 20.0);
    }

    public Mercator(double lat0, double lon0, double par) {
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.lat0 = lat0;
        this.lon0 = lon0;
        this.par = par;
        this.lat0_r = Math.toRadians(lat0);
        this.lon0_r = Math.toRadians(lon0);
        this.par_r = Math.toRadians(par);
        this.precalculate();
        this.addParameter("Projection_Name", "mercator");
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("standard_parallel", par);
    }

    private void precalculate() {
        this.A = EARTH_RADIUS * Math.cos(this.par_r);
        this.y0 = this.A * SpecialMathFunction.atanh(Math.sin(this.lat0_r));
    }

    public double getParallel() {
        return this.par;
    }

    public void setParallel(double par) {
        this.par = par;
        this.precalculate();
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = lon;
        this.lon0_r = Math.toRadians(lon);
        this.precalculate();
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = lat;
        this.lat0_r = Math.toRadians(lat);
        this.precalculate();
    }

    public String paramsToString() {
        return " origin " + this.origin.toString() + " parellel: " + Format.d(this.getParallel(), 6);
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0;
    }

    public Object clone() {
        Mercator cl = (Mercator)super.clone();
        cl.origin = new LatLonPointImpl(this.getOriginLat(), this.getOriginLon());
        return cl;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof Mercator)) {
            return false;
        }
        Mercator oo = (Mercator)proj;
        return this.getParallel() == oo.getParallel() && this.getOriginLat() == oo.getOriginLat() && this.getOriginLon() == oo.getOriginLon() && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double fromLat_r = Math.toRadians(fromLat);
        if (Math.abs(90.0 - Math.abs(fromLat)) < 1.0E-6) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.A * Math.toRadians(LatLonPointImpl.range180(fromLon - this.lon0));
            toY = this.A * SpecialMathFunction.atanh(Math.sin(fromLat_r)) - this.y0;
        }
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double toLon = Math.toDegrees(fromX / this.A) + this.lon0;
        double e = Math.exp(-(fromY += this.y0) / this.A);
        double toLat = Math.toDegrees(1.5707963267948966 - 2.0 * Math.atan(e));
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }
}

