/*  Difference of Gaussians - Difference of Gaussians Method for nucleus center detection in 3D data 
 *  Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 *  Barbara Rizzi brizzi08@gmail.com
 *  Paul Bourgine paul.bourgine@polytechnique.edu
 *  
 *  To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 *  You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
*/



#ifndef centers_detection_h
#define centers_detection_h

#include <itkImage.h>
#include <itkImageFileReader.h>
#include <itkImageFileWriter.h>
#include <itkRescaleIntensityImageFilter.h>
#include <itkRecursiveGaussianImageFilter.h>
#include <itkImageRegionIterator.h>
#include <itkImageRegionConstIterator.h>

#include <vtkPolyData.h>
#include <vtkDoubleArray.h>
#include <vtkPoints.h>
#include <vtkSmartPointer.h>

#include <vnl/algo/vnl_symmetric_eigensystem.h>
#include <string>

#include <sys/stat.h>


/*****************************************************************************************/

template < class TInputImage >
class ReadingPreprocessingData
{	
  // Reads the data and rescale them in [0,1]. 
  // If nameMembranes is not an empty string, the data processed are calculated as:
  // weight*nuclei - membranes. 
  // Default value for 'weight' is 3.0
  public:
    static typename TInputImage::Pointer ReadingPreprocessing( std::string nameNuclei, std::string nameMembranes = "", float weight = 3.0f);
  
  private:
    static typename TInputImage::Pointer ReadingRescaling(std::string name);
};

/*****************************************************************************************/

template < class TInputImage >
class DifferenceOfGaussian
{	
  // Calculates the difference between two images convolved with two Gaussians with std 'stdSmall' and 'stdBig'
  // then performs a threshold of the result
  public:
    static typename TInputImage::Pointer PerformDifferenceOfGaussian(typename TInputImage::Pointer Image, float stdSmall, float stdBig, float threshold,bool fileExists1, bool fileExists2,std::string nameStdSmall, std::string nameStdBig);
    
  private:
    static typename TInputImage::Pointer GaussianConvolution(typename TInputImage::Pointer Image, float std);
};

/*****************************************************************************************/

template < class TInputImage >
class Centers
{
  public:    
    typedef typename TInputImage::PixelType DataType;
    typedef typename TInputImage::RegionType::IndexType DataIndexType;

    Centers( typename TInputImage::Pointer image );
    
    vtkSmartPointer< vtkPolyData > GetCenters( typename  TInputImage::Pointer image );
	    
  private:
    int xSize;
    int ySize;
    int zSize;
    
    typename TInputImage::PixelType xSpacing;
    typename TInputImage::PixelType ySpacing;
    typename TInputImage::PixelType zSpacing;

    struct Position
    {
	int x;	
	int y;
	int z;
    };

    struct Neighb
    {
	std::vector< Position > connected;
    };
	
    std::vector< Neighb > regions;
    typename TInputImage::Pointer FindLocalMaxima( typename TInputImage::Pointer image ); 
    vtkSmartPointer< vtkPolyData > RefineCenters( typename TInputImage::Pointer image );
};

#ifndef ITK_MANUAL_INSTANTIATION
#include "centers_detection.txx"
#endif

#endif
