/*  Difference of Gaussians - Difference of Gaussians Method for nucleus center detection in 3D data 
 *  Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 *  Barbara Rizzi brizzi08@gmail.com
 *  Paul Bourgine paul.bourgine@polytechnique.edu
 *  
 *  To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 *  You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
*/


#ifndef UTILITIES_H
#define UTILITIES_H

#include <unistd.h>
#include <iostream>
#include <string>

using namespace std;

bool fexists(string strFilename) 
{
  struct stat stFileInfo;
  bool blnReturn;
  int intStat;
  // Attempt to get the file attributes
  intStat = stat(strFilename.c_str(),&stFileInfo);
  if(intStat == 0)
  {
    blnReturn = true;
  } 
  else 
  {
    blnReturn = false;
  }

  return(blnReturn);
}

class Parameters
{
  public:
   Parameters( int argc, char** argv ) 
   {
     int index;
     int k;
     stringstream ss;
     while ((k = getopt (argc, argv, "n:m:o:d:w:s:b:t:")) != -1)
     switch (k)
     {
      case 'n':
	fullFileNameNuclei = string(optarg);
	break;
      case 'm':
	fullFileNameMembranes = string(optarg);
	break;
      case 'o':
	fullCentersName = string(optarg);
	break;
      case 'd':
	tmpDir = string(optarg);
      case 'w':	
	ss.str("");
	ss.clear();
	ss << optarg;
	ss >> weight;
	if( ss.good() ) 
	{ 
	  cerr<<" error reading the value of parameter 'weight'"<<endl; 
	  exit(EXIT_FAILURE); 	  
	} 
	break;
      case 's':
	ss.str("");
	ss.clear();
	ss << optarg;
	ss >> stdSmall;
	if( ss.good() ) 
	{ 
	  cerr<<" error reading the value of parameter 'stdSmall'"<<endl; 
	  exit(EXIT_FAILURE); 	  
	} 
	break;
      case 'b':	
	ss.str("");
	ss.clear();
	ss << optarg;
	ss >> stdBig;
	if( ss.good() ) 
	{ 
	  cerr<<" error reading the value of parameter 'stdBig'"<<endl; 
	  exit(EXIT_FAILURE); 	  
	} 
	break;
      case 't':
	ss.str("");
	ss.clear();
        ss << optarg;
	ss >> threshold;
	if( ss.good() ) 
	{ 
	  cerr<<" error reading the value of parameter 'threshold'"<<endl; 
	  exit(EXIT_FAILURE); 	  
	} 
	break;	
      case '?':n:m:c:d:w:s:b:t:
	if ( (optopt == 'n') || (optopt == 'm') || (optopt == 'o') || (optopt == 'd') || (optopt == 'w') || (optopt == 's') ||
	     (optopt == 'b') || (optopt == 't'))
               fprintf (stderr, "Option -%c requires an argument.\n", optopt);
	else
	  cerr<<"Unknown option character: "<<optopt<<endl;
      default:
	abort();
    }  
  }
  inline string getFullFileNameNuclei() const { return fullFileNameNuclei; }// input
  inline string getFullFileNameMembranes() const { return fullFileNameMembranes; }// input 
  inline string getFullFileNameCenters() const { return fullCentersName; }// output
  inline string getTmpDir() const { return tmpDir; }
  inline double getWeight() const { return weight; }
  inline double getStdSmall() const { return stdSmall; }
  inline double getStdBig() const { return stdBig; }
  inline double getThreshold() const { return threshold; }
  
  private:
   string fullFileNameNuclei;
   string fullFileNameMembranes;
   string fullCentersName;	
   double weight;
   double stdSmall;
   double stdBig;
   double threshold;	
   string tmpDir; 
};

#endif
