/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */

#include "itkRGBPixel.h"
#include "itkNumericSeriesFileNames.h"
#include "itkImageSeriesReader.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkImageAdaptor.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageFileReader.h"
#include "itkRescaleIntensityImageFilter.h"

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "sys/stat.h"

#include "vtkLSMReader.h"
#include "vtkStructuredPointsWriter.h"

#include "itkImageToVTKImageFilter.h"


using namespace std;



int main( int argc, char *argv[] ) 
{
	bool errorarg=0;
	std::string Extens=std::string(" ");
    std::string Folder=std::string(" ");
    std::string AllName=std::string(" ");
    if(argc<2){
		printf("Syntax : LSM2VTK <input-filename.lsm> with Optional:<output-filename>\n");
		return -1;
	}
	
	int i=0;
    char * FileName=argv[1];
	if(strlen(FileName)<4){ printf(" %s is not a valid LSM file ... \n",FileName); return -1;}
    if(strstr (FileName,"lsm")==NULL  && strstr(FileName,"LSM")==NULL){ printf(" %s is not a valid LSM file ... \n",FileName); return -1; }
    
    char * OutputFolderName="";
    if(argc>2) OutputFolderName=argv[2];
    else{
        OutputFolderName=(char *)malloc(strlen(FileName)-3);
        strncpy (OutputFolderName,FileName,strlen(FileName)-4); OutputFolderName[strlen(FileName)-4]='\0';        
    }
	
    
  
	printf(" Read %s \n",FileName);
	
	std::vector< vtkLSMReader * > m_LSMReaders;
	m_LSMReaders.push_back( vtkLSMReader::New() );
	m_LSMReaders.front()->SetFileName(FileName);
	m_LSMReaders.front()->Update();
	
	int m_NumberOfChannels = m_LSMReaders[0]->GetNumberOfChannels();
	int m_NumberOfTimePoints = m_LSMReaders[0]->GetNumberOfTimePoints();
	
	std::cout << m_LSMReaders[0]->GetDescription() << std::endl;
	printf(" -> Number of time points : %d\n -> Number of channel : %d\n",m_NumberOfTimePoints,m_NumberOfChannels);
	
	
	
	for ( i = 1; i < m_NumberOfChannels; i++ )
	{
		m_LSMReaders.push_back( vtkLSMReader::New() );
		m_LSMReaders[i]->SetFileName( FileName);
		m_LSMReaders[i]->SetUpdateChannel(i);
	}
	
	for ( i = 0; i < m_NumberOfChannels; i++ )
	{
		m_LSMReaders[i]->Update();
		vtkImageData *image3d = m_LSMReaders[i]->GetOutput();
		
		stringstream NameOut; NameOut<<OutputFolderName<<"_ch0"<<i<<".vtk";
		printf("Write %s\n",(NameOut.str()).c_str());
		
		vtkStructuredPointsWriter *writer = vtkStructuredPointsWriter::New();
		writer->SetFileTypeToBinary();
		writer->SetInput(image3d);
		writer->SetFileName((NameOut.str()).c_str());
		writer->Write();
	}
	
	for ( unsigned int i = 0; i < m_LSMReaders.size(); i++ )
	{
		m_LSMReaders[i]->Delete();
	}
	
	
	return 0;
}
