/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#include "itkRGBPixel.h"
#include "itkNumericSeriesFileNames.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkImageAdaptor.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageFileReader.h"
#include "itkRescaleIntensityImageFilter.h"

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "sys/stat.h"


#include "itkImageToVTKImageFilter.h"


using namespace std;



int main( int argc, char *argv[] ) 
{
	if(argc<3){
		printf("Syntax : ConvertShortToByte <input-filename> <output-filename>\n");
        return -1;
		
	}
	char * InFileName=argv[1];
	char * OutFileName=argv[2];
	
	printf(" Read %s \n",InFileName);
	
	using namespace std;
	typedef unsigned short InputPixelType;
	typedef itk::Image< InputPixelType,  3 > InputImageType;
    typedef itk::ImageFileReader< InputImageType > ReaderType;
	
	ReaderType::Pointer reader=ReaderType::New();
	reader->SetFileName( InFileName);
	
	
	typedef unsigned char OutputPixelType;
	typedef itk::Image< OutputPixelType,  3 > OutputImageType;
	
	typedef itk::RescaleIntensityImageFilter< InputImageType, OutputImageType > RescalerType;
	RescalerType::Pointer rescaler = RescalerType::New();
	rescaler->SetOutputMinimum(  0  );
	rescaler->SetOutputMaximum( 255 );
	rescaler->SetInput( reader->GetOutput() );

	
	printf(" Write %s \n",OutFileName);

	typedef itk::ImageFileWriter< OutputImageType > WriterType;
	WriterType::Pointer writer=WriterType::New();
	writer->SetFileName( OutFileName);
	writer->SetInput(rescaler->GetOutput());
	writer->Write();
	
	return 0;
}
