/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkBXDProcessingWin32Header.h,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkBXDProcessingWin32Header - manage Windows system differences
// .SECTION Description
// The vtkBXDProcessingWin32Header captures some system differences between Unix
// and Windows operating systems. 

#ifndef __vtkBXDProcessingWin32Header_h
#define __vtkBXDProcessingWin32Header_h

//#include <VTKBXDConfigure.h>

#if defined(WIN32) && !defined(VTKBXD_STATIC)
#if defined(vtkBXDProcessing_EXPORTS)
#define VTK_BXD_PROCESSING_EXPORT __declspec( dllexport )
#else
#define VTK_BXD_PROCESSING_EXPORT __declspec( dllimport )
#endif
#else
#define VTK_BXD_PROCESSING_EXPORT
#endif

#endif
