/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */

// Read a tiff series and creates a RGB volume

#include "itkRGBPixel.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkImageFileReader.h"

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"



int main( int argc, char *argv[] )
{
    
    
    const   unsigned int   Dimension = 3;
    
    
    std::ostringstream oss;
    
    int stackT=1;//72;
    if(argc<3){
        printf("COMMAND : ConvertVTKto3DTIFF <inputfile.vtk> <outputfile.tiff> \n");
        return -1;
    }
    
    char * inputfile=argv[1];
    char * outputfile=argv[2];
    printf("Convert VTK to 3D Volume TIFF from %s to %s\n",inputfile,outputfile);
    
    
    using namespace std;
    typedef unsigned char InputPixelType;
    typedef itk::Image< InputPixelType,  Dimension > InputImageType;
    typedef itk::ImageFileReader< InputImageType > ReaderType;
    
    ReaderType::Pointer reader=ReaderType::New();
    reader->SetFileName( inputfile);
    reader->Update();
    
    InputImageType::SpacingType spacing;
    spacing= reader->GetOutput()->GetSpacing();
    
    InputImageType::RegionType region = reader->GetOutput()->GetLargestPossibleRegion();
    InputImageType::SizeType size = region.GetSize();
    
    std::stringstream infos;infos<<outputfile<<".txt";
    FILE *fp = fopen((infos.str()).c_str(),"w");
    fprintf(fp,"DIMENSIONS %d %d %d\n",size[0],size[1],size[2]);
    fprintf(fp,"SPACING %f %f %f\n",spacing[0],spacing[1],spacing[2]);
    fclose(fp);
    
    typedef unsigned char                      OutputPixelType;
    typedef itk::Image< OutputPixelType, Dimension > Image3DRGBType;
    typedef itk::ImageFileWriter< Image3DRGBType > WriterType;
   
    WriterType::Pointer writer=WriterType::New();
    writer->SetFileName( outputfile);
    writer->SetInput(reader->GetOutput());
    
    
    try
    {
        writer->Update();
       // printf(" Write %s \n",outputfile);
    }
    catch( itk::ExceptionObject & excp )
    {
        printf(" CANNOT Write %s \n",outputfile);
        std::cerr << "Exception caught " << excp << std::endl;
        //  return 1;
    }
    
    

    return 0;

}

