#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.


PATHDESTINATION=$1
VTK_HOME="${PATHDESTINATION}/lib/VTK/VTK_5.10.1"
CMAKER="${PATHDESTINATION}/lib/CMAKE/cmake-3.0.2/bin/cmake"
mkdir ../EXE


# pre-compil
${CMAKER} -DVTK_DIR:PATH="$VTK_HOME"   -DCMAKE_BUILD_TYPE:STRING="Release"   ../SRC 

if [ $? -ne 0 ]; then
  echo "BioEmergences - ConvertVTKtoPolydata PRE-COMPILATION ERROR"
  exit -1
fi


# compil
make 

if [ $? -ne 0 ]; then
  echo "BioEmergences - ConvertVTKtoPolydata COMPILATION ERROR"
  exit -1
fi

 echo "BioEmergences - ConvertVTKtoPolydata compilation OK"
 exit 0


