/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
// Read a lineage tree in LNG format and convert to EMB format for Mov-IT

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"

#include <iostream>
#include <sstream>
#include <string>
#include <fstream>

#include <map>
#include <list>
#include <vector>

#include "math.h"
#include <time.h>
#include <algorithm>

#include <stdarg.h>

#include <cstring>


using namespace std;

vector<string> split(string str,string delims);
float * EmptyVector();
float * EmptyVector(int n);
char * ReadArg(int argc, char* argv[] , string Name);

int main( int argc, char *argv[] )
{
    
    if(argc<3){
        printf("COMMAND : ConvertLNGtoEMB --inputfile <inputfile.lng>  --outputfile <outputfile.emb> --SpacingX <SpacingX> --SpacingY <SpacingY> --SpacingZ <SpacingZ> --ImageSizeX <ImageSizeX> --ImageSizeY <ImageSizeY> --ImageSizeZ <ImageSizeZ>\n");
        return -1;
    }
    
    char * inputfile=ReadArg(argc,argv,"inputfile");
    char * outputfile=ReadArg(argc,argv,"outputfile");
    float * Spacing=EmptyVector();
    Spacing[0]=atof(ReadArg(argc,argv,"SpacingX"));
    Spacing[1]=atof(ReadArg(argc,argv,"SpacingY"));
    Spacing[2]=atof(ReadArg(argc,argv,"SpacingZ"));
    float * ImageSize=EmptyVector();
    ImageSize[0]=atof(ReadArg(argc,argv,"ImageSizeX"));
    ImageSize[1]=atof(ReadArg(argc,argv,"ImageSizeY"));
    ImageSize[2]=atof(ReadArg(argc,argv,"ImageSizeZ"));
    
    
    
    char *buffer = (char *)malloc(4096);
    FILE *fp = fopen(inputfile,"r");
    printf("ConvertLNGtoEMB -> READ %s \n",inputfile);
    fgets(buffer,4096,fp);
    //Cell ID, Cell Mother ID, X, Y, Z, Time, Vx, Vy, vZ, Virtual, Name, Center Number,Deformation, Distance
    
    map< long , map<long, long > > TimeCenter;
    
    map< long , float * > CoordXYZ;
    
    long timeBegin=1000000;
    long timeEnd=0;
    while(!feof(fp)){
        std::vector<string> TabSpliter=split(buffer,",");
        long ID=atol(TabSpliter[0].c_str());
        long mother=atol(TabSpliter[1].c_str()); if(mother<=0) mother=-1;
        float *XYZ=EmptyVector();
        XYZ[0]=atof(TabSpliter[2].c_str());
        XYZ[1]=atof(TabSpliter[3].c_str());
        XYZ[2]=atof(TabSpliter[4].c_str());
        long time=atoi(TabSpliter[5].c_str());  if(time<timeBegin)timeBegin=time;if(time>timeEnd)timeEnd=time;
        
        TimeCenter[time][ID]=mother;
        CoordXYZ[ID]=XYZ;
        fgets(buffer,4096,fp);
        TabSpliter.clear();
    }
    
    fclose(fp);
    FILE *fpw = fopen(outputfile,"w");
    printf("ConvertLNGtoEMB -> WRITE %s \n",outputfile);
    long n=1;
    std::map<long,long> Correspond;
    std::map<long,long> CorrespondCN;
    for(long time=timeBegin;time<=timeEnd;time++){
        fprintf(fpw,"0;0;0;0;0;%ld;0;0\n",time);
        long motherNumber=1;
        for(std::map<long,long>::iterator it = TimeCenter[time].begin(); it!= TimeCenter[time].end(); ++it){
            long ID =(*it).first;
            float * XYZ=CoordXYZ[ID];
            long CN=n;
            long mother=(*it).second;
            if(mother<=0) n++;
            else {
                CN=CorrespondCN[mother];
                mother=Correspond[mother];
            }
            Correspond[ID]=motherNumber; motherNumber++;
            CorrespondCN[ID]=CN;
            fprintf(fpw,"%ld;%ld;%d;%d;%d;%ld;%ld;-1\n",1000000+ID,CN,(int) round(XYZ[0]/Spacing[0]-(int)round(ImageSize[0]/2)),(int) round(XYZ[1]/Spacing[1]-(int)round(ImageSize[1]/2)),(int)  round(XYZ[2]/Spacing[2]),time,mother);
            
        }
    }
    
    fclose(fpw);
    
    
    
    return 0;
    
}


vector<string> split(string str,string delims)
{
    // Skip delims at beginning, find start of first token
    string::size_type lastPos = str.find_first_not_of(delims, 0);
    // Find next delimiter @ end of token
    string::size_type pos     = str.find_first_of(delims, lastPos);
    
    // output vector
    vector<string> tokens;
    
    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delims.  Note the "not_of". this is beginning of token
        lastPos = str.find_first_not_of(delims, pos);
        // Find next delimiter at end of token.
        pos     = str.find_first_of(delims, lastPos);
    }
    
    return tokens;
}
float * EmptyVector(){return EmptyVector(3);}
float * EmptyVector(int n){
    //float * V=new float[3];
    float * V=(float*)malloc(n * sizeof (float));
    for(int i=0;i<n;i++)V[i]=0.0;
    return V;
}


char * ReadArg(int argc, char* argv[] , string Name){
    Name="--"+Name;
    for(int a=1;a<argc-1;a++)
        if(strcmp(Name.c_str(),argv[a])==0)
            return argv[a+1];
    
    printf(" PB IN ARGUMENT -> '%s' NO EXIST \n",Name.c_str());
    exit(0);
    return "";
}
