#!/bin/bash

# Geodesic Mean Curvature Flow - Geodesic Mean Curvature Flow Method for 3D image filtering 
# Written in 2015 by Karol Miikula mikula@math.sk
# Robert Cunderlik cunderli@svf.stuba.sk
# Robert Spir spir.robert@gmail.com
# Alessandro Sarti alessandro.sarti@ehess.fr
# Zuzana Kriva kriva@math.sk
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1
BIOALGOS="${PATHDESTINATION}/Algorithmes/"
MPI="${PATHDESTINATION}/lib/MPICH/mpich/bin/mpicc"


mkdir ../EXE



#Build
${MPI} -o ../EXE/gmcf-par -O3 ../SRC/gmcf-par.c -lm
if [ $? -ne 0 ]; then
  echo "BioEmergences - gmcfFiletering compilation failed"
  exit -1
fi

 echo "BioEmergences - gmcfFiletering compilation OK"
 exit 0


