# GSubSurf - Generalized Subjective Surface Method for segmentation in 3D 
# Written in 2015 by Karol Mikula mikula@math.sk
# Robert Spir spir.robert@gmail.com
# Mariana Remesikova remesikova@math.sk
# Alessandro Sarti alessandro.sarti@ehess.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

channel=ch00 # channel used by the algorithm
embryoType=1 # Type of embryo: 1 - big, 2 small
iter=250 #total number of steps of the algorithm
K=1000.0 #edge detection :  bigger K preserve more edges (but also noise) 
tau=0.1 # step for the segmentation method
sigma=0.0001 #step for the linear diffusion used for presmoothing the gradient in edge detection function (bigger sigma means more smoothing of the gradient inside the edge detection function)
Vadv=10.0 # parameter for  speed of advection in GSUBSURF model
Vcurv=0.2 #parameter for speed of mean curvature flow in GSUBSURF model
epsilon=1.0e-6  #regularization parameter  which is used to prevent zero gradients in denominators of the numerical scheme
edgePower=1 #parameter inside the edge detection function - the norm of gradient is given to the edge_power
convolutionU=1 # if it is equal 1 the linear diffusion smoothing (convolution) is applied to segmented image if 0 the convolution is not applied.
convolutionPMC=0 # if it is equal 1 the linear diffusion smoothing (convolution) is applied to edge dector function evaluated in each voxel if 0 the convolution is not applied
