#!/bin/sh

# SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# Paul Bourgine paul.bourgine@polytechnique.edu
# Alessandro Sarti alessandro.sarti@ehess.fr
# Camilo Melani camilomelani@gmail.com
# Rene Doursat rene.doursat@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1
BIOALGOS="${PATHDESTINATION}/Algorithmes/"
MPI_HOME="${PATHDESTINATION}/lib/MPICH/mpich"
ITK_HOME="${PATHDESTINATION}/lib/ITK/ITK_4.6.1"
VTK_HOME="${PATHDESTINATION}/lib/VTK/VTK_5.10.1"
ANN_HOME="${PATHDESTINATION}/lib/ANN/ANN_1.1.2"
BOOST_HOME="${PATHDESTINATION}/lib/BOOST/boost_1.55.0"
CMAKER="${PATHDESTINATION}/lib/CMAKE/cmake-3.0.2/bin/cmake"

mkdir -p ../EXE
rm -rf CMakeCache.txt CMakeFiles

# pre-compil
${CMAKER}  \
    -DBOOST_ROOT:PATH="${BOOST_HOME}" \
    -DBOOST_INCLUDEDIR:PATH="${BOOST_HOME}/include"  \
    -DBOOST_LIBRARYDIR:PATH="${BOOST_HOME}/lib" \
    -DANN_DIR:PATH="$ANN_HOME"  \
    -DVTK_DIR:PATH="$VTK_HOME"  \
    -DBoost_NO_SYSTEM_PATHS:STRING="ON"   \
    -DMPI_INCLUDE_PATH:PATH="${MPI_HOME}/include" \
    -DMPI_LIBRARIES:PATH="${MPI_HOME}/lib" \
    -DMPI_COMPILER:STRING="${MPI_HOME}/bin/mpicc" \
    -DMPIEXEC:STRING="${MPI_HOME}/bin/mpiexec" \
    -DMPI_CXX_COMPILER:STRING="${MPI_HOME}/bin/mpic++" \
    -DCMAKE_BUILD_TYPE:STRING="Release"  \
    ../SRC 


if [ $? -ne 0 ]; then
  echo "BioEmergences - SimulatedAnnealing pre-compilation failed"
  exit -1
fi
#Otherwise lib are connected in OSX
cp -f ${BOOST_HOME}/lib/* ../EXE/

# compil
make 

if [ $? -ne 0 ]; then
  echo "BioEmergences - SimulatedAnnealing compilation failed"
  exit -1
fi

 echo "BioEmergences - SimulatedAnnealing compilation OK"
 exit 0
