/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#include "CelluleType.h"
#include <iostream>
#include <math.h>
#include <list>

CelluleType::~CelluleType()
{
}

std::ostream& operator<< ( std::ostream& ofs, const CelluleType& Cell )
{
  return ofs;
}



CelluleType::CelluleType () : picked ( 0 ), IsNewBourne ( false ),hasIntensity ( false ),m_Intensity(0) ,Deformation(0), Virtual(0)
{

}


CelluleType::CelluleType ( double x, double y, double z, long t, long CenterNumber, long IdDb ) :  X(x), Y(y), Z(z), T(t), CenterNumber(CenterNumber ), picked ( 0 ), IsNewBourne ( false ), hasIntensity ( false ),m_Intensity(0),IdDb(IdDb),DX(0), DY(0), DZ(0),Deformation(0), Virtual(0)
{

}


double CelluleType::GetIntensity(double radious)
{
  if ( !this->hasIntensity )
  {
//    CalcIntensity(radious);
  }
  return m_Intensity;
}

void CelluleType::GetPosition(float vector[3])
{
  vector[0] = this->X;
  vector[1] = this->Y;
  vector[2] = this->Z;
}

//Return the distance between the center and the vector
float CelluleType::GetDistance(float vector[3])
{
  float aPosition[3];
  this->GetPosition(aPosition);
  float distance = sqrt(pow(vector[0]-aPosition[0],2)+pow(vector[1]-aPosition[1],2)+pow(vector[2]-aPosition[2],2));
  return distance;
}


void CelluleType::GetDirection(float vector[3])
{
  vector[0] = this->DX;
  vector[1] = this->DY;
  vector[2] = this->DZ;
}
float CelluleType::GetDirection(int vector)
{
  if(vector==0) return this->DX;
  if(vector==1) return this->DY;
  if(vector==2) return this->DZ;
}


void CelluleType::SetDirection(float vector[3])
{
  this->DX=vector[0];
  this->DY=vector[1];
  this->DZ=vector[2];
}

void CelluleType::SetDirection(float vx,float vy,float vz)
{
  this->DX=vx;
  this->DY=vy;
  this->DZ=vz;
}


bool CelluleType::operator==(const CelluleType& c) const
{
  return this->X == c.X && this->Y == c.Y && this->Z == c.Z && this->T == c.T;
} 

bool CelluleType::IsInBounds(std::vector< float > bounds)
{
  float position[3];
  this->GetPosition(position);

  if (!((bounds[0]<position[0] && position[0]<bounds[1]) && 
         (bounds[2]<position[1] && position[1]<bounds[3]) && 
         (bounds[4]<position[2] && position[2]<bounds[5])))
  {
    return false;
  }
  else
  {
    return true;
  }
}




void CelluleType::CalcIntensity(double radious)
{
//     ImageType::Pointer image = this->GetimageProvider()->GetImage ( this->GetT(), 1 );
//     
//     ImageType::SpacingType Spacing;
//     ImageType::SizeType Size;
// 
//     Spacing = image->GetSpacing();
//     Size = image->GetLargestPossibleRegion().GetSize();
// 
//     ImageType::IndexType index;
//     ImageType::IndexType index_tmp;
// 
//     int radiusx = radious/Spacing[0];
//     int radiusy = radious/Spacing[1];
//     int radiusz = radious/Spacing[2];
//     
//     index[0] = floor ( this->GetX() / Spacing[0] );	//indici del volume
//     index[1] = floor ( this->GetY() / Spacing[1] );
//     index[2] = floor ( this->GetZ() / Spacing[2] );
//     
//     
//     
//     float mean_pixel_value = 0;	//valore medio
//     //Creazione maschera e controllo dei bordi
//     int i_min = index[0] - radiusx;
//     if ( i_min < 0 ) i_min = 0;
//     int i_max = index[0] + radiusx;
//     if ( i_max >= Size[0] - 1 ) i_max = Size[0] - 1;
// 
//     int j_min = index[1] - radiusy;
//     if ( j_min < 0 ) j_min = 0;
//     int j_max = index[1] + radiusy;
//     if ( j_max >= Size[1] - 1 ) j_max = Size[1] - 1;
// 
//     int k_min = index[2] - radiusz;
//     if ( k_min < 0 ) k_min = 0;
//     int k_max = index[2] + radiusz;
//     if ( k_max >= Size[2] - 1 ) k_max = Size[2] - 1;
// 
//     int mask_voxels = ( k_max - k_min + 1 ) * ( j_max - j_min + 1 ) * ( i_max - i_min + 1 );
// 
//     for ( int k = k_min; k <= k_max; k++ )
//     {
//       for ( int j = j_min; j <= j_max; j++ )
//       {
//         for ( int i = i_min; i <= i_max; i++ )
//         {
//           index_tmp[0] = i;
//           index_tmp[1] = j;
//           index_tmp[2] = k;
//           float value = image->GetPixel ( index_tmp );
//           mean_pixel_value += value;
//         }
//       }
//     }
//     mean_pixel_value = mean_pixel_value / mask_voxels;
// 
// 
//     this->m_Intensity = mean_pixel_value;
// 
//     hasIntensity = true;

}
