/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __downloadfromdb_h
#define __downloadfromdb_h

#include<occi.h>

using namespace oracle::occi;
using namespace std;

#include "CelluleType.h"
#include "MethodType.h"

#include <ostream>
#include <sstream>
#include <iostream>
#include <list>
#include <map>
#include <stdio.h>
#include <stdlib.h>

/*! \brief DownloadFromDB
 * The class download Cells from DataBase ORACLE
 */
	
	
	class  DownloadFromDB 
{
  public:
    typedef DownloadFromDB Self;
	
private:
	Environment*   env;
	Connection*  con ;
	
	std::map< int, float * > VectorField;
	std::map< int, float * > CenterList;
	std::map< int, int > CorrespondIdName;

	std::vector<std::string> ListDownloadFields;
	 std::map< int, int> ListDivisionRate;



public:
	DownloadFromDB (std::vector<std::string> ListDownloadFields);
	~DownloadFromDB ();
	int Open();
	int Close();
 	std::map< int, CelluleType * >  DownloadCells(int id_time,int id_process_segmentation, int id_process_center);
 	void AddSegmentationCells(std::map< int, CelluleType * > &ListCells , int id_time,int id_process_segmentation);

	std::list< MethodType * > ListMethods();
	
	void AddStateCells(std::map< int, CelluleType * > &ListCells , std::list< MethodType * > ListAlgoAnote, int id_time,int id_process_segmentation);
	void AddStateCells(std::map< int, CelluleType * > &ListCells ,int id_time,int id_process_segmentation,MethodType * AlgoAnote);
 	
 	std::map< int, int>  DownloadDivisionRate(int id_process_tracking);
 	
 	std::map< int, int * > DownloadTree(int id_time,int id_process_tracking,int id_process_center);
 	std::map<int, FeaturesType * > ListFeaturesPhases(int id_process_segmentation);
 	void AddStateNul(CellType * Cell,MethodType * AlgoAnote);
 	
private:
	char * CreateRequestFeatures();
	FeaturesType CreateCellFeature(ResultSet*  rCellList,int begin );
	void DownloadVectorFields(int id_time, int id_process_center);
	void DownloadCenters(int id_time,int id_process_segmentation);

};
#endif


