/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */

//

#ifndef __IOfunctions_h
#define __IOfunctions_h

#include <iostream>
#include <set>
#include <sstream>
#include <strstream> 
#include <boost/random.hpp>



template< class E >
void SetPoints2Vtk ( std::ostream& ofs, std::set< E* > &setPoints)
{
  // iterate over all the edges.
  std::string header1;
  std::string header2;
  std::ostrstream points;
  std::ostrstream vectors;

  for (typename std::set< E* >::iterator it = setPoints.begin(); it!= setPoints.end(); ++it   )
  {
    //Get the distance between s and v
    E* a_Cell = (*it);
    points << a_Cell->GetX() << " " << a_Cell->GetY() << " " << a_Cell->GetZ() << " ";
  }
  
  
  ofs << "# vtk DataFile Version 3.0\n" ;
  ofs << "vtk output\n" ;
  ofs << "ASCII\n";
  ofs << "DATASET POLYDATA\n";
  ofs << "POINTS " << setPoints.size() << " float\n";
  ofs << points.str() << "\n";
}


template< class E >
    void SetVectors2Vtk ( std::ostream& ofs, std::set< double* > setVectors)
{
  // iterate over all the edges.
  std::string header1;
  std::string header2;
  std::ostrstream points;

  
  for (typename std::set< E* >::iterator it = setVectors.begin(); it!= setVectors.end(); ++it   )
  {
    //Get the distance between s and v
    points << (*it)[0] << " " << (*it)[1] << " " << (*it)[2] << " ";
  }
  
  ofs << "POINT_DATA " << setVectors.size() << "\n";
  ofs << "POINTS Vector double\n";
  ofs << points.str() ;
}



template< class E >
    double SampleNormal1 ( double mean, double sigma ) 
{

    // Create a Mersenne twister random number generator
  // that is seeded once with #seconds since 1970
  static boost::mt19937 rng ( static_cast<unsigned> ( std::time ( 0 ) ) );

  // select Gaussian probability distribution
  boost::normal_distribution<double> norm_dist ( mean, sigma );

  // bind random number generator to distribution, forming a function
  boost::variate_generator<boost::mt19937&, boost::normal_distribution<double> >  normal_sampler ( rng, norm_dist );

  // sample from the distribution
  return normal_sampler();
}



#endif
