/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __regression_h
#define __regression_h

#include <list>
#include <map>

//Function Exponentielle X^2 ,x^3 etc..
inline double ExpoS(double Va,int CoeffVa){ double ReVa=1; for(int i=0;i<CoeffVa;i++) ReVa*=Va; return ReVa;}



inline  double Sum( std::list<double> ListX,int ValueX, std::list<double> ListY,int ValueY){
	
	std::list< double >::iterator IterListY=ListY.begin();;
    double SumT=0;
 	for(std::list< double >::iterator IterListX = ListX.begin(); IterListX!= ListX.end(); ++IterListX){	
 		double ValFinX=ExpoS(*IterListX,ValueX);
 		double ValFinY=ExpoS(*IterListY,ValueY);
 		IterListY++;
 		
 		 SumT+=ValFinX*ValFinY;
 	}
 	return SumT;
}


inline  double Sum( std::list<double> ListX,int Value){

    double SumT=0;
 	for(std::list< double >::iterator IterListX = ListX.begin(); IterListX!= ListX.end(); ++IterListX){
 	 	SumT+=ExpoS(*IterListX,Value);
 	 	//printf("SumT %f ExpoS(%f,%d) %f \n",SumT,*IterListX,Value,ExpoS(*IterListX,Value));
 	}
 //printf("SumT %f \n",SumT);
 	return SumT;
}

inline  std::list< double > Regression_Polynomiale(std::list<double> X,std::list<double> Y,int N){
	
	//printf("N %d",N);
	double SX=Sum(X,1);
	double SX2=Sum(X,2);
	double SX3=Sum(X,3);
	double SX4=Sum(X,4);
	//printf(" SX %f, SX2 %f, SX3 %f , SX4 %f ",SX,SX2,SX3,SX4);
	double SY=Sum(Y,1);
	//printf(" SY %f ",SY);
	double SX2Y1=Sum(X,2,Y,1);
	double SX1Y1=Sum(X,1,Y,1);
	
	//printf(" SX2Y1 %f, SX2Y1 %f",SX2Y1,SX1Y1);
		
	double D=SX4*( N*SX2-SX*SX) - SX3*(N*SX3-SX2*SX)+SX2*(SX*SX3-SX2*SX2);
	double A2= ( SX2Y1 * (N*SX2-SX*SX) - SX3 * (N*SX1Y1 - SX*SY) + SX2* (SX1Y1*SX-SY*SX2) ) /D;
	double A1= (SX4 * ( N * SX1Y1 - SX*SY) - SX2Y1 * (N * SX3 - SX2*SX) + SX2*(SY*SX3-SX1Y1*SX2)) / D;
	double A0= ( SX4 * ( SX2 * SY - SX*SX1Y1) - SX3 * (SX3*SY - SX2*SX1Y1) + SX2Y1 * ( SX*SX3-SX2*SX2)) / D;
	//printf("D %f, A2 %f, A1 %f, A0 %f \n",D,A2,A1,A0);
	std::list< double > A;

	
	double DT=SX4*(N*SX2-ExpoS(SX,2))-SX3*(N*SX3-SX2*SX)+SX2*(SX*SX3-ExpoS(SX2,2));
	double A2T=( SX2Y1 * (N*SX2-ExpoS(SX,2)) - SX3 * (N*SX1Y1 - SX*SY) + SX2 * (SX1Y1*SX - SY*SX2)) / D;
	double A1T =(SX4 * (N * SX1Y1 - SX*SY) - SX2Y1 * (N*SX3-SX2*SX)+SX2*(SY*SX3-SX1Y1*SX2))/D;
	double A0T = ( SX4 * (SX2*SY-SX*SX1Y1)-SX3*(SX3*SY-SX2*SX1Y1)+SX2Y1*(SX*SX3-ExpoS(SX2,2)) ) /D;
	//printf("TEMP D %f, A2 %f, A1 %f, A0 %f \n",DT,A2T,A1T,A0T);
	
	A.push_back(A0T);
	A.push_back(A1T);
	A.push_back(A2T);
	
	return A;
}







inline double ValeurRegression(std::list<double> X,std::list<double> Y,int Val,int N){

	std::list< double > AA=Regression_Polynomiale(X,Y,N);
	
	double ReturnVal=0;
	int CoeffVa=0;
	for(std::list< double >::iterator IterAA= AA.begin(); IterAA!= AA.end(); ++IterAA){
   		double ACoeff = (*IterAA);
   		
   		ReturnVal=ACoeff*ExpoS((float)Val,CoeffVa);
   		//printf("Val %d , ACoeff %f  a %d , ReturnVal %f; ",Val,ACoeff,CoeffVa,ReturnVal);
   		CoeffVa++;
	}
	//printf("\n");
	return ReturnVal;
}




#endif

