/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __EmbryoStateType_h
#define __EmbryoStateType_h


#include <list>
#include <set>
#include <boost/archive/xml_iarchive.hpp>
#include <boost/shared_ptr.hpp>


/*!
*/
template < typename EPtr >
class EmbryoStateType
{

  public:
    typedef EmbryoStateType Self;
  public:
    typedef typename std::set< EPtr >  SetType;
    typedef typename SetType::iterator iterator;

    virtual void GetNearestNCells ( double point[3], long nn, std::list< EPtr > &list ) = 0;
    virtual void AddCell ( EPtr p_Cell ) = 0;
    virtual void DeallocateCells ( ) = 0;
    virtual void GetNearestNCells ( EPtr a_Cell, long direction,long nn, std::list< EPtr > &list ) = 0;
    virtual EPtr GetCellByNumber ( long cell_number );

    void CalcIntensity ( );
    virtual void InvalidateLocator ( ) = 0;


    virtual iterator begin() = 0;
    virtual iterator end() = 0;

    virtual long size() = 0;


    friend class boost::serialization::access;
    template<class Archive> void serialize ( Archive & ar, const unsigned int version )
    {
    }
};

template <class EPtr>
void EmbryoStateType<EPtr>::CalcIntensity ( )
{

  for ( iterator it = begin(); it != end();++it )
  {
    EPtr cell = *it;
    cell->GetIntensity ( 3 );
  }
}


template <class EPtr>
EPtr EmbryoStateType<EPtr>::GetCellByNumber ( long cell_number )
{
  for ( iterator it = begin();it != end();++it )
  {
    if ( ( *it )->GetCenterNumber() == cell_number )
    {
      return ( *it );
    }
  }
  //return NULL;
}


#endif
