/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#include "ImageProvider.h"

#include <numeric>
#include <boost/foreach.hpp>
#include <itkImageFileReader.h>
#include <itkImage.h>
#include <iostream>

#include "itkImageFileReader.h"
#include <boost/format.hpp>

ImageProvider::~ImageProvider()
{

}


void ImageProvider::SetPattern( std::string pPattern )
{
 m_pattern =  pPattern ;
}
ImageProvider::ImageProvider ( ) : m_Directory (std::string ( "TempImages" ))
{
//  if (!file::exists( m_Directory ))
//  {
//    file::create_directory( m_Directory);
//  }
}


ImageType::Pointer ImageProvider::GetImage ( long ptime,long channel)
{
  KeyType pair= std::make_pair(ptime,channel);
  
  MapTimeImageType::iterator imagePointer;
  imagePointer = m_cache.find ( pair );

  if ( imagePointer == m_cache.end() )
  {
    if ( m_cache.size() > 10 )
    {
      //Erase the image to dispose.
      int randNumber;
      randNumber =  rand() % m_cache.size();
      
      MapTimeImageType::iterator cacheit = m_cache.begin();
      std::advance ( cacheit, randNumber ) ;

      m_cache.erase ( cacheit );
    }

    boost::format fmter ( m_pattern );
    fmter % ptime % channel;
    std::string fileName  = fmter.str();

    int found = fileName.find_last_of ( "/\\" );
    std::string directory = fileName.substr ( 0, found );
    std::string name = fileName.substr ( found + 1 );


    //File Exist Already download?
    //Read the image.
    ReaderType::Pointer reader = ReaderType::New();
    reader->SetFileName ( m_Directory + "/" + name );
    try
    {
      reader->Update();
    }
    catch ( itk::ExceptionObject &e )
    {
      //file Not downloaded
      //download the Image
      system ( "Sinit" );

      std::ostringstream ossSget;
      ossSget << "Sget -v " << fileName << " " << m_Directory;
      std::cout << ossSget.str().c_str() << std::endl;

      system ( ossSget.str().c_str() );

      try
      {
        reader->Update();
      }
      catch ( itk::ExceptionObject &e )
      {
        std::cerr << "Faillure to read the data" << std::endl;
        std::cerr << e << std::endl;
        exit ( EXIT_FAILURE );
      }
    }

    m_cache[pair] = reader->GetOutput();
    imagePointer = m_cache.find ( pair );
  }

  else
  {
    int i = 0;
  }
  return imagePointer->second;
}

