/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
//
#ifndef energytype_h
#define energytype_h

#include "SingularCallBack.h"



template < class Class, typename ReturnType, typename Parameter1, typename Parameter2 >
    class EnergyType:public SingularCallBack < Class, ReturnType, Parameter1, Parameter2>
{
  public:
    typedef SingularCallBack < Class, ReturnType, Parameter1, Parameter2> Superclass;


    typedef ReturnType (Class::*Method)(Parameter1,Parameter2);

    EnergyType(){};
    EnergyType(std::string p_name, double p_weight, Class* _class_instance, Method _method):Superclass(p_name, p_weight, _class_instance, _method){};

  ~EnergyType(){};
  
  friend class boost::serialization::access;
  template<class Archive> void serialize ( Archive & ar, const unsigned int version )
  {
    ar & boost::serialization::base_object<SingularCallBack> ( *this );
  }

  
};

#endif
