/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef Recorder_h
#define Recorder_h

#include <boost/config.hpp>
#include <boost/graph/depth_first_search.hpp>
#include <boost/graph/properties.hpp>
#include <boost/graph/graph_concepts.hpp>
#include <boost/graph/overloading.hpp>
#include <boost/static_assert.hpp>



namespace boost {

  namespace detail {


    template <class ComponentsMap>
        class properties_recorder : public dfs_visitor<>
    {
      typedef typename property_traits<ComponentsMap>::value_type comp_type;
      public:
        properties_recorder(ComponentsMap c, 
                            comp_type& c_count)
        : m_component(c), m_count(c_count) {}

/*        template <class Vertex, class Graph>
      void start_vertex(Vertex, Graph&) {
            if (m_count == (std::numeric_limits<comp_type>::max)())
            m_count = 0; // start counting components at zero
            else
            ++m_count;
    }
*/
        template <class Vertex, class Graph>
        void discover_vertex(Vertex u, Graph&) {
                  if (get(m_component,u) == true)
                  {
                    ++m_count;
                  }
                  else
                  {

                  }
                  put(m_component, u, m_count);
                }
      protected:
        ComponentsMap m_component;
        comp_type& m_count;
    };

  } // namespace detail

}



#endif

