#!/bin/bash
# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.


PATHDESTINATION=$1
#INSTALL ANN LIBRARY
#DOC ON http://www.cs.umd.edu/~mount/ANN/

version="1.1.2"
cd "${PATHDESTINATION}/lib/ANN/ANN_${version}"
ANN_HOME=`pwd`

os=$(uname)
if [ "$os" == "Darwin" ]; then
	make macosx-g++ -j8
fi
if [ "$os" == "Linux" ]; then
	make linux-g++ -j8
fi

if [ $? -ne 0 ]; then
	 echo "BioEmergences - COMPILATION ANN ERROR IN ${ANN_HOME}"
	 exit 1
fi

echo "BioEmergences - COMPILATION ANN OK IN ${ANN_HOME}"