#!/bin/bash
# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.


PATHDESTINATION=$1
BIOALGOS="${PATHDESTINATION}/Algorithmes/"

function patch
{
  local ALGO=$1
  local PATHDESTINATION=$2
  PATHDESTINATIONSLASH=$(echo ${PATHDESTINATION}  | sed 's/\//\\\//g')
  # sed 's/PATHDESTINATION=$1/PATHDESTINATION=TEMP/g' ${ALGO}/LaunchLocal.sh > temp.txt
  # sed 's/PATHDESTINATION=\/Users\/emmanuelfaure\//PATHDESTINATION=TEMP/g' ${ALGO}/LaunchLocal.sh > temp.txt
  # sed 's/PATHDESTINATION=TEMP/PATHDESTINATION=${PATHDESTINATIONSLASH}/g' temp.txt > ${ALGO}/LaunchLocal.sh 
  sed 's/PATHDESTINATION=$1/PATHDESTINATION=TEMP/g' ${ALGO}/LaunchLocal.sh > temp.txt
  sed 's/PATHDESTINATION=\/Users\/emmanuelfaure\//PATHDESTINATION=TEMP/g' ${ALGO}/LaunchLocal.sh > temp.txt
  sed 's/PATHDESTINATION=TEMP/PATHDESTINATION="\$\(O="\$\(cd "\$\(dirname "\$0"\)" \&\& pwd\)\/\$\(basename "\$0"\)"; while \[ \! -e "\$O\/\.bioemergences" -a "\$O" \!= "\/" \]; do O="\$\(dirname "\$O"\)"; done; echo "\$O"\)"/g' temp.txt > ${ALGO}/LaunchLocal.sh
}


ALGO="${BIOALGOS}/Filtering/gmcfFiltering"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 7 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/CenterDetect/DifferenceGaussian"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 8 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/CenterDetect/LevelsetCenterDetection"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 9 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/Segmentation/MembraneSegmentation"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 10 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/Segmentation/NucleiSegmentation"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
bash compil.sh "${PATHDESTINATION}"
patch ${ALGO} "${PATHDESTINATION}" || exit 1
echo 11 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/Tracking/SimulatedAnnealing"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 12 > ${PATHDESTINATION}/.bioemergences

ALGO="${BIOALGOS}/Converter/Convert3DTIFFtoVTK"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1

ALGO="${BIOALGOS}/Converter/ConvertVTKto3DTIFF"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1

ALGO="${BIOALGOS}/Converter/ConvertCentersTXTtoVTK"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1

ALGO="${BIOALGOS}/Converter/MergeVTK"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1


ALGO="${BIOALGOS}/Converter/ConvertCentersVTKtoTXT"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1


ALGO="${BIOALGOS}/Converter/ConvertLSMtoVTK"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1


ALGO="${BIOALGOS}/Converter/ConvertVTKtoPolydata"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1

ALGO="${BIOALGOS}/Converter/CreateMOV-IT"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
patch ${ALGO} "${PATHDESTINATION}"
bash compil.sh "${PATHDESTINATION}" || exit 1

ALGO="${BIOALGOS}/Converter/ExportMOV-ITCenters"
echo  "BioEmergences - Compilation  ${ALGO}"
cd "${ALGO}/MAK"
bash compil.sh "${PATHDESTINATION}" || exit 1
echo 13 > ${PATHDESTINATION}/.bioemergences
