#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.


PATHDESTINATION=$1
CMAKER="${PATHDESTINATION}/lib/CMAKE/cmake-3.0.2/bin/cmake"

#INSTALL ITK LIBRARY
#DOC ON http://www.itk.org
version="4.6.1"
cd "${PATHDESTINATION}/lib/ITK/ITK_${version}"
ITK_HOME="$(pwd)"
${CMAKER} -DBUILD_EXAMPLES:STRING="OFF" -DBUILD_TESTING:STRING="OFF" -DITK_BUILD_DEFAULT_MODULES="OFF"  -DITK_USE_CONCEPT_CHECKING="OFF" -DModule_ITKImageIntensity="ON" -DModule_ITKSmoothing="ON"  -DITKGroup_Bridge="ON" ../InsightToolkit-${version}
if [ $? -ne 0 ]; then
	 echo  "BioEmergences - PRE-COMPILATION ITK ERROR IN ${ITK_HOME}"
	 exit 1
fi

make -j8
if [ $? -ne 0 ]; then
	 echo  "BioEmergences - COMPILATION ITK ERROR IN ${ITK_HOME}"
	 exit 1
fi


echo  "BioEmergences - COMPILATION ITK OK IN ${ITK_HOME}"