#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1


#INSTALL MPICH LIBRARY
MPICH_HOME="${PATHDESTINATION}/lib/MPICH/mpich"

version="3.1.3"
cd "${PATHDESTINATION}/lib/MPICH/"
if [ -e  "mpich-${version}.tar.gz" ]; then
	tar -xf mpich-${version}.tar.gz
	rm -f mpich-${version}.tar.gz
fi
cd "mpich-${version}"

./configure --disable-fortran --disable-f77 --disable-f90 --prefix="${MPICH_HOME}" 
if [ $? -ne 0 ]; then
	 echo "BioEmergences - CONFIGURE MPICH ERROR IN ${MPICH_HOME}"
	 exit 1
fi
make -j8
#2>make.txt
if [ $? -ne 0 ]; then
	 echo "BioEmergences - COMPILATION MPICH ERROR IN ${MPICH_HOME}"
	 exit 1
fi
make install
if [ $? -ne 0 ]; then
	 echo "BioEmergences - INSTALL MPICH ERROR IN ${MPICH_HOME}"
	 exit 1
fi


echo "BioEmergences - COMPILATION MPICH OK IN ${MPICH_HOME}"