#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1
CMAKER="${PATHDESTINATION}/lib/CMAKE/cmake-3.0.2/bin/cmake"

#INSTALL VTK LIBRARY
#DOC ON http://www.Vtk.org

version="5.10.1"
cd "${PATHDESTINATION}/lib/VTK/VTK_${version}"
VTK_HOME="$(pwd)"
${CMAKER} -DBUILD_EXAMPLES:STRING="OFF"  -DBUILD_TESTING:STRING="OFF" ../VTK${version}
if [ $? -ne 0 ]; then
	 echo  "BioEmergences - COMPILATION VTK ERROR IN ${VTK_HOME}"
	 exit 1
fi
make -j8
if [ $? -ne 0 ]; then
	 echo  "BioEmergences - COMPILATION VTK ERROR IN ${VTK_HOME}"
	 exit 1
fi


 echo  "BioEmergences - COMPILATION VTK OK IN ${VTK_HOME}"