#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.


echo "************************************************************"
echo "************** INSTALL BIOEMERGENCES WORKFLOW **************"
echo "************************************************************"

PATHDESTINATION="$(pwd)"

case "$PATHDESTINATION" in
    *\ * ) echo "Some external libraries cannot be compiled with space in the working path. Please, move the BioEmergences-Workflow folder in a space-less directory path." && exit 1;;
    * ) echo "";;
esac

scriptdir="InstallScript"

os=$(uname)
echo " OS : $os "
if [ "$os" == "Darwin" ]; then
	gpp=$(which g++)
	if [ "$gpp" == "" ]; then
		echo " **************  BIOEMERGENCES **************>>>>> No compiler found"
		echo " **************  BIOEMERGENCES **************>>>>> You have to download and install XCode from the apple store, or the command line tools : https://developer.apple.com/xcode/downloads/"
		exit 1
	fi
fi

if [ "$os" == "Linux" ]; then
	pack=""
	gpp=$(which g++)
	if [ "$gpp" == "" ]; then
		pack="${pack} build-essential"  
	fi 
	dpkg -s freeglut3-dev >package.txt
	if [ $? -ne 0 ]; then
	 	pack="${pack} freeglut3 freeglut3-dev"
	fi
	dpkg -s default-jre >>package.txt
	if [ $? -ne 0 ]; then
	 	pack="${pack}  default-jre "
	fi
	if [ "$pack" != "" ]; then
		echo " **************  BIOEMERGENCES **************>>>>> Install packages $pack, please enter your password"
		sudo apt-get update
		sudo apt-get -y install $pack
	fi
	rm -f package.txt
fi



echo " **************  BIOEMERGENCES **************>>>>> Install Librairies"
bash "${scriptdir}"/Install_ANN.sh "${PATHDESTINATION}"  || exit 1 

bash "${scriptdir}"/Install_CMAKE.sh "${PATHDESTINATION}"  || exit 1 

bash "${scriptdir}"/Install_MPICH.sh "${PATHDESTINATION}"  || exit 1 

bash "${scriptdir}"/Install_BOOST.sh "${PATHDESTINATION}"  || exit 1 

bash "${scriptdir}"/Install_ITK.sh "${PATHDESTINATION}"  || exit 1 

bash "${scriptdir}"/Install_VTK.sh "${PATHDESTINATION}"  || exit 1 



echo " **************  BIOEMERGENCES **************>>>>> Compile  Algorithms"
bash "${scriptdir}"/Install_Algos.sh "${PATHDESTINATION}"  || exit 1 

echo " **************  BIOEMERGENCES **************>>>>> Install Mov-IT"
bash "${scriptdir}"/Install_BioEmergencesMovit.sh "${PATHDESTINATION}"  || exit 1 

echo " **************  BIOEMERGENCES **************>>>>> Install LOCI 2 VTK"
bash "${scriptdir}"/Install_Loci2VTK.sh "${PATHDESTINATION}"  || exit 1 

echo " **************  BIOEMERGENCES **************>>>>> Install BioEmergences GUI"
bash "${scriptdir}"/Install_BioEmergencesGUI.sh "${PATHDESTINATION}"  || exit 1 

mv "${scriptdir}/update" "${PATHDESTINATION}/"
chmod 755 "${PATHDESTINATION}/update"

echo  "**************  BIOEMERGENCES **************>>>>> Remove Install Script"
rm -fr ${scriptdir}
rm -f install.sh

echo  "**************  BIOEMERGENCES **************>>>>> Running GUI"
if [ "${os}" == "Linux" ]
then
  "${PATHDESTINATION}/BioEmergences"
elif [ "${os}" == "Darwin" ]
then
  "${PATHDESTINATION}/BioEmergences.app/Contents/MacOS/JavaAppLauncher"
fi

