#!/bin/bash


#  Difference of Gaussians - Difference of Gaussians Method for nucleus center detection in 3D data 
#  Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
#  Barbara Rizzi brizzi08@gmail.com
#  Paul Bourgine paul.bourgine@polytechnique.edu
#
#  To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
#  You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION="$(O="$(cd "$(dirname "$0")" && pwd)/$(basename "$0")"; while [ ! -e "$O/.bioemergences" -a "$O" != "/" ]; do O="$(dirname "$O")"; done; echo "$O")"
BIWF_ALGOSDIR="${PATHDESTINATION}/Algorithmes"
MPI_HOME="${PATHDESTINATION}/lib/MPICH/mpich"
MPI="${MPI_HOME}/bin/mpiexec"
YOU_CAN_CLOSE="*** You can now close the window ***";

echo " === Difference of Gaussians CenterDetection ==="
echo ""
echo "Starting at `date`"

algodir="${BIWF_ALGOSDIR}/CenterDetect/DifferenceGaussian/"
source "${algodir}/Parameters.sh"

if [ -d "$1" ]; then
  inputDir="$1"
else
  echo "$1 is not a directory"
  echo "${YOU_CAN_CLOSE}"
  exit 1
fi
echo "Input Directory : $inputDir"

if [ -n "$1" ]; then
  outputDir="$2"
else
  echo "You must specify an output path"
  echo "${YOU_CAN_CLOSE}"
  exit 1
fi

echo "Output Directory : $outputDir"
mkdir -p "$outputDir"

weight=0
iterations=0
dt=0.1
#############################
# DO NOT EDIT BELOW THIS LINE

exe="${algodir}/EXE/centers_detection"
cd "$inputDir/"

echo 'progression=0' > "${algodir}/.run"
ntotal=$(ls *${channel}*.vtk* | wc -l)
ncurrent=0

for file in *${channel}*.vtk*
do
  if [ ! -e "${outputDir}/${file}" ];
  then
    "${exe}" -n "${inputDir}/${file}" -o "${outputDir}/${file}" -w ${weight} -s ${stdSmall} -b ${stdBig} -t ${threshold} -d "${outputDir}/"

    printf "Removing working files: "
    rm -f "${outputDir}"/*_std_*.vtk && echo 'OK'
  else
    echo "File ${outputDir}/${file} already exist"
  fi

  ncurrent=$((ncurrent + 1))
  echo "progression=$((${ncurrent} * 100 / ${ntotal}))" > "${algodir}/.run"
done

. "${BIWF_ALGOSDIR}/HelperFunctions.sh"

echo "Creates a fake tracking"
lineage="${outputDir}/fake.lineageTree"
printf '' > "${lineage}"
currentID=100000

echo "Extracts Dimensions and Spacing"
rawvtk="$(ls "${inputDir}"/*${channel}*.vtk* | head -n 1)"
processVTK "${rawvtk}" "${outputDir}"

rm -rf "${output}"
rm -rf "${outputDir}/tmp"

echo "Building fake lineage"
mkdir -p "${outputDir}/Centers"
for vtk in "${outputDir}/"*.vtk
do
  echo "${vtk}"
  # Extract timestep
  timestep=$(basename "${vtk}" | grep -oE '_t[0-9]+')
  timestep=${timestep:2}

  # Convertion
  txt="${outputDir}/Centers/Centers_t${timestep}.txt"
  cn=0
  for coord in $(tail -n +6 "${vtk}")
  do
    printf ${coord} >> "${txt}"

    cn=$((cn + 1))
    if [ $((cn % 3)) -eq 0 ]
    then
      printf '\n' >> "${txt}"
    else
      printf ' ' >> "${txt}"
    fi
  done

  # Adding each centers to the fake lineage
  while read line
  do
    X=$(echo "${line}" | awk '{print $1}')
    Y=$(echo "${line}" | awk '{print $2}')
    Z=$(echo "${line}" | awk '{print $3}')

    printf '%s,-1,%s,%s,%s,%s,0,0,0,0,0,0,0,0\n' ${currentID} ${X} ${Y} ${Z} $(echo ${timestep} | sed 's/^0*//') >> "${lineage}"
    currentID=$((currentID + 1))
  done < "${txt}"
done

rm -r "${outputDir}/Centers"

#Export Lineage for Mov-IT
emblineage="${outputDir}/fake_lineage.emb"

if [ ! -e "${emblineage}" ];
then
  echo "Export $lineage to $emblineage"   
    ${BIWF_ALGOSDIR}/Converter/CreateMOV-IT/EXE/ConvertLNGtoEMB \
    --inputfile ${lineage} \
    --outputfile ${emblineage} \
    --SpacingX ${sx} \
    --SpacingY ${sy} \
    --SpacingZ ${sz} \
    --ImageSizeX ${n1} \
    --ImageSizeY ${n2} \
    --ImageSizeZ ${n3}  
fi

rm -f "${lineage}"

if [ -e "${algodir}/.run" ]
then
  rm -f "${algodir}/.run"
fi

echo "${YOU_CAN_CLOSE}"
