/*  Difference of Gaussians - Difference of Gaussians Method for nucleus center detection in 3D data 
 *  Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 *  Barbara Rizzi brizzi08@gmail.com
 *  Paul Bourgine paul.bourgine@polytechnique.edu
 *  
 *  To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 *  You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
*/


#ifndef TIMER_H
#define TIMER_H

#include <time.h>

class Timer
{
    clock_t startTime;

 public:
    Timer() {
        startTime = clock();
    }

    ~Timer() {}

    double timePassed() {
        return (clock()-startTime)/(double)(CLOCKS_PER_SEC);
    }

    void reset() {
        startTime = clock();
    }
};

#endif // TIMER_H
