#!/bin/bash
PATHDESTINATION="$(O="$(cd "$(dirname "$0")" && pwd)/$(basename "$0")"; while [ ! -e "$O/.bioemergences" -a "$O" != "/" ]; do O="$(dirname "$O")"; done; echo "$O")"
BIWF_ALGOSDIR="${PATHDESTINATION}/Algorithmes"
MPI_HOME="${PATHDESTINATION}/lib/MPICH/mpich"
MPI="${MPI_HOME}/bin/mpiexec"
YOU_CAN_CLOSE="*** You can now close the window ***";

echo " === LevelSet CenterDetection ==="
echo ""
echo "Starting at `date`"

algodir="${BIWF_ALGOSDIR}/CenterDetect/LevelsetCenterDetection/"
source "${algodir}/Parameters.sh"
procs=$(getconf _NPROCESSORS_ONLN)   #initialize this with an automatic value based on the number of processors available
per_iter=$iter     #periodicity of writing, in this case, 1 write per 100 iterations

if [ -d "$1" ]; then
  inputDir="$1"
else
  echo "$1 is not a directory."
  echo "${YOU_CAN_CLOSE}"
  exit 1
fi

echo "Input Directory : $inputDir"

if [ -n "$1" ]; then
  outputDir="$2"
else
  echo "You must specify an output path. "
  echo "${YOU_CAN_CLOSE}"
  exit 1
fi

echo "Output Directory : $outputDir"
mkdir -p "$outputDir"


#============DO NOT EDIT BELOW==============
. "${BIWF_ALGOSDIR}/HelperFunctions.sh"

exe="${algodir}/EXE/centerdetect-par" #path to the executable
writeImage=0

echo 'progression=0' > "${algodir}/.run"
ntotal=$(ls "${inputDir}"/*${channel}*.vtk* | wc -l)
ncurrent=0

#run the algorithm on all files in the inputDir
for file in "$inputDir"/*${channel}*.vtk*
do
  baseName="$(basename "${file}")"
  strippedName="${baseName%.*}"
  outputFileVTK="${outputDir}/${strippedName}.vtk"
  outputFile="${outputDir}/${strippedName}.txt"
  
  if [ ! -e  "$outputFileVTK" ];
  then
    processVTK "$file" "$outputDir"
    
    if [ ! -e  "$outputFile" ];
    then
      input="$tempDir/ $binaryData ${n3} ${n2} ${n1} ${F} ${D} ${treshold} ${epsilonD} ${epsilonF} ${tau} ${iter} ${per_iter} ${writeImage}"

      echo ${input} | "${MPI}" -n ${procs} "${exe}" #> "$outputDir"/xxx-t$inputFile

      lastiter=$(ls "${tempDir}" | grep -oE '_[0-9]+_' | sort -rg | head -n 1)
      cat "$tempDir"/part_centers${lastiter}* >"$outputFile" 
    fi

    rm -r "$tempDir" #cleanup
    rmdir "$output"
  
    "${BIWF_ALGOSDIR}"/Converter/ConvertCentersTXTtoVTK/EXE/ConvertCentersTXTtoVTK \
    --inputfile  "$outputFile" \
    --outputfile "$outputFileVTK"  \
    --SpacingX ${sx} \
    --SpacingY ${sy} \
    --SpacingZ ${sz} 

    rm -f "$outputFile"
  fi

  ncurrent=$((ncurrent + 1))
  echo "progression=$((${ncurrent} * 100 / ${ntotal}))" > "${algodir}/.run"
done

echo "Creates a fake tracking"
lineage="${outputDir}/fake.lineageTree"
printf '' > "${lineage}"
currentID=100000

echo "Extracts Dimensions and Spacing"
rawvtk="$(ls "${inputDir}"/*${channel}*.vtk* | head -n 1)"
processVTK "${rawvtk}" "${outputDir}"

rm -rf "${output}"
rm -rf "${outputDir}/tmp"

echo "Building fake lineage"
mkdir -p "${outputDir}/Centers"
for vtk in "${outputDir}/"*.vtk
do
  echo "${vtk}"
  # Extract timestep
  timestep=$(basename "${vtk}" | grep -oE '_t[0-9]+')
  timestep=${timestep:2}

  # Convertion
  txt="${outputDir}/Centers/Centers_t${timestep}.txt"
  cn=0
  for coord in $(tail -n +6 "${vtk}")
  do
    printf ${coord} >> "${txt}"

    cn=$((cn + 1))
    if [ $((cn % 3)) -eq 0 ]
    then
      printf '\n' >> "${txt}"
    else
      printf ' ' >> "${txt}"
    fi
  done

  # Adding each centers to the fake lineage
  while read line
  do
    X=$(echo "${line}" | awk '{print $1}')
    Y=$(echo "${line}" | awk '{print $2}')
    Z=$(echo "${line}" | awk '{print $3}')

    printf '%s,-1,%s,%s,%s,%s,0,0,0,0,0,0,0,0\n' ${currentID} ${X} ${Y} ${Z} $(echo ${timestep} | sed 's/^0*//') >> "${lineage}"
    currentID=$((currentID + 1))
  done < "${txt}"
done

rm -r "${outputDir}/Centers"

#Export Lineage for Mov-IT
emblineage="${outputDir}/fake_lineage.emb"

if [ ! -e "${emblineage}" ];
then
  echo "Export $lineage to $emblineage"   
    "${BIWF_ALGOSDIR}"/Converter/CreateMOV-IT/EXE/ConvertLNGtoEMB \
    --inputfile "${lineage}" \
    --outputfile "${emblineage}" \
    --SpacingX ${sx} \
    --SpacingY ${sy} \
    --SpacingZ ${sz} \
    --ImageSizeX ${n1} \
    --ImageSizeY ${n2} \
    --ImageSizeZ ${n3}  
fi

rm -f "${lineage}"

if [ -e "${algodir}/.run" ]
then
  rm -f "${algodir}/.run"
fi

echo "${YOU_CAN_CLOSE}"
