// Read a tiff series and creates a RGB volume

/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */ 

#include "itkRGBPixel.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkImageFileReader.h"

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"



int main( int argc, char *argv[] )
{
    
    
    const   unsigned int   Dimension = 3;
    
    
    std::ostringstream oss;
    
    int stackT=1;//72;
    if(argc<3){
        printf("COMMAND : Convert3DTIFFtoVTK <inputfile> <outputfile>  <SpacingX> <SpacingY> <SpacingZ> \n");
        return -1;
    }
    
    char * inputfile=argv[1];
    char * outputfile=argv[2];
    float SpacingWidth=atof(argv[3]);
    float SpacingHeight=atof(argv[4]);
    float SpacingDepth=atof(argv[5]);
    printf("Convert 3D Volume TIFF %s to  VTK %s \n",inputfile,outputfile);
    
    
    typedef unsigned char                      InputPixelType;
    typedef unsigned char                      OutputPixelType;
    typedef itk::Image< InputPixelType, Dimension > Image3DRGBType;
    typedef itk::ImageFileReader< Image3DRGBType > Reader;
    typedef itk::Image< OutputPixelType, Dimension >   OutputImageType;
    
    
    Reader::Pointer reader= Reader::New();
    reader->SetFileName(inputfile);
    reader->Update();
    
    // Set Spacing
    Image3DRGBType::SpacingType spacingRed;
    spacingRed[0] = SpacingWidth;
    spacingRed[1] = SpacingHeight;
    spacingRed[2] = SpacingDepth;
    
    
    reader->GetOutput()->SetSpacing(spacingRed);
    reader->Update();
    
    
    typedef itk::ImageFileWriter< OutputImageType > Writer3DgrayRedType;
    Writer3DgrayRedType::Pointer writer3DgrayRed = Writer3DgrayRedType::New();
    
    writer3DgrayRed->SetFileName(outputfile);
    writer3DgrayRed->SetInput( reader->GetOutput() );
    
    
    try
    {
        writer3DgrayRed->Update();
        //printf(" Write %s \n",outputfile);
    }
    catch( itk::ExceptionObject & excp )
    {
        printf(" CANNOT Write %s \n",outputfile);
        std::cerr << "Exception caught " << excp << std::endl;
        //  return 1;
    }
    
    

    return 0;

}

