// Read a lineage tree in LNG format and convert to EMB format for Mov-IT
/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"

#include <iostream>
#include <sstream>
#include <string>
#include <fstream>

#include <map>
#include <list>
#include <vector>

#include "math.h"
#include <time.h>
#include <algorithm>

#include <stdarg.h>

#include <cstring>


using namespace std;

vector<string> split(string str,string delims);
float * EmptyVector();
float * EmptyVector(int n);
char * ReadArg(int argc, char* argv[] , string Name);

int main( int argc, char *argv[] )
{
    
    if(argc<3){
        printf("COMMAND : ConvertCentersVTKtoTXT --inputfile <inputfile.vtk>  --outputfile <outputfile.txt> --SpacingX <SpacingX> --SpacingY <SpacingY> --SpacingZ <SpacingZ>\n");
        return -1;
    }
    
    char * inputfile=ReadArg(argc,argv,"inputfile");
    char * outputfile=ReadArg(argc,argv,"outputfile");
    float * Spacing=EmptyVector();
    Spacing[0]=atof(ReadArg(argc,argv,"SpacingX"));
    Spacing[1]=atof(ReadArg(argc,argv,"SpacingY"));
    Spacing[2]=atof(ReadArg(argc,argv,"SpacingZ"));
    printf(" Convert Centers VTK %s to TXT %s \n ",inputfile,outputfile);
    
    
    
    
    
    
    char *buffer = (char *)malloc(4096);
    FILE *fp = fopen(inputfile,"r");
    fgets(buffer,4096,fp);
    fgets(buffer,4096,fp);//# vtk DataFile Version 3.0
    fgets(buffer,4096,fp);//vtk output
    fgets(buffer,4096,fp);//ASCII
    fgets(buffer,4096,fp);//DATASET POLYDATA
    fgets(buffer,4096,fp);//POINTS 2877 double
    map< int , float * > CoordXYZ;
    int id=0;
    while(!feof(fp)){
        std::vector<string> TabSpliter=split(buffer," ");
        for(int i=0;i<TabSpliter.size()-1;i+=3){
            float *XYZ=EmptyVector();
            XYZ[0]=atof(TabSpliter[i].c_str())/Spacing[0];
            XYZ[1]=atof(TabSpliter[i+1].c_str())/Spacing[1];
            XYZ[2]=atof(TabSpliter[i+2].c_str())/Spacing[2];
            CoordXYZ[id]=XYZ;
            id++;
        }
        fgets(buffer,4096,fp);
        TabSpliter.clear();
    }
    fclose(fp);
    // printf("WRITE %s\n",outputfile);
    
    FILE *fpw = fopen(outputfile,"w");
    int n=0;
    for(int i=0;i<id;i++){
        float * XYZ=CoordXYZ[i];
        fprintf(fpw,"%d %d %d \n",(int)round(XYZ[0]),(int)round(XYZ[1]),(int)round(XYZ[2]));
    }
    fclose(fpw);
    
    
    
    return 0;
    
}


vector<string> split(string str,string delims)
{
    // Skip delims at beginning, find start of first token
    string::size_type lastPos = str.find_first_not_of(delims, 0);
    // Find next delimiter @ end of token
    string::size_type pos     = str.find_first_of(delims, lastPos);
    
    // output vector
    vector<string> tokens;
    
    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delims.  Note the "not_of". this is beginning of token
        lastPos = str.find_first_not_of(delims, pos);
        // Find next delimiter at end of token.
        pos     = str.find_first_of(delims, lastPos);
    }
    
    return tokens;
}
float * EmptyVector(){return EmptyVector(3);}
float * EmptyVector(int n){
    //float * V=new float[3];
    float * V=(float*)malloc(n * sizeof (float));
    for(int i=0;i<n;i++)V[i]=0.0;
    return V;
}


char * ReadArg(int argc, char* argv[] , string Name){
    Name="--"+Name;
    for(int a=1;a<argc-1;a++)
        if(strcmp(Name.c_str(),argv[a])==0)
            return argv[a+1];
    
    printf(" PB IN ARGUMENT -> '%s' NO EXIST \n",Name.c_str());
    exit(0);
    return "";
}
