#!/bin/bash
# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION="$(O="$(cd "$(dirname "$0")" && pwd)/$(basename "$0")"; while [ ! -e "$O/.bioemergences" -a "$O" != "/" ]; do O="$(dirname "$O")"; done; echo "$O")"
BIWF_ALGOSDIR="${PATHDESTINATION}/Algorithmes"

function usage {
  echo " USAGE: bash LaunchLocal.sh <input directory> <output directory> "
  echo " WHERE <input directory> contain VTK files "
  exit
}


if [ -d $1 ]; then
  inputDir=$1
else
  usage
fi
if [ -n $1 ]; then
  outputDir=$2
  if [ "$outputDir" == "" ]; then 
  	usage
  fi
else
  usage
fi



for inputFile in $inputDir/*.vtk*
do
  outputfile=${outputDir}/$(basename ${inputFile%.*}.tiff)
  ${BIWF_ALGOSDIR}/Converter/ConvertVTKto3DTIFF/EXE/ConvertVTKto3DTIFF ${inputFile} ${outputfile}
  rm -f ${outputfile}.txt

done
