/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
//standard C include

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"
#include <sstream>
#include <iostream>
#include <sstream>
#include <string>
#include <fstream>

#include <map>
#include <list>
#include <vector>

//VTK include
#include "vtkPolyDataReader.h"
#include "vtkStructuredPointsReader.h"
#include "vtkStructuredPoints.h"
#include "vtkDiscreteMarchingCubes.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyData.h"
#include "vtkImageReader.h"
#include "vtkDecimatePro.h"
#include "vtkAppendPolyData.h"
#include "vtkFloatArray.h"
#include "vtkPointData.h"
#include "vtkPolyDataNormals.h"

/**************************************** main program
 ******************************************/
using namespace std;
vector<string> split(string str,string delims);
int main( int argc, char * argv[] )
{
    if(argc<3){
        printf(" ConvertVTKtoPolydata <inputfile> <id files> <outputfile>");
        return -1;
    }
    
    // read parameters
     char *inputLabelImage = argv[1];
     char *idfiles = argv[2];
     char *outputPolyData = argv[3];
    
   
     
    
    printf(" Load %s \n",inputLabelImage);
    // read input (a segmented image)
    vtkStructuredPointsReader* labelImageReader =vtkStructuredPointsReader::New();
    labelImageReader->SetFileName(inputLabelImage);
    labelImageReader->Update();
    
    
    vtkStructuredPoints* image =  labelImageReader->GetOutput();
    vtkAppendPolyData *tot_isosurface = vtkAppendPolyData::New();
    
    
    
    //get the maximum label
    double range[2];
    image->GetScalarRange(range);
    printf("label are from %g to %g\nCreating isosurfaces\n",range[0],range[1]);
    for(int i=1;i<(int)range[1];i++){
        
        printf("Creating isosurface for Cell %d\n",i);
        //creating the isosurface
        vtkDiscreteMarchingCubes* label2PolyData = vtkDiscreteMarchingCubes::New();
        label2PolyData->SetInput( image );
        //label2PolyData->SetValue(i,i);
        label2PolyData->GenerateValues(1, i, i+1);
        label2PolyData->Update();
        
        //clean the polydata
        vtkDecimatePro * proDecimate=vtkDecimatePro::New();
        proDecimate->SetInput(label2PolyData->GetOutput());
        proDecimate->SetTargetReduction(0.9);
        proDecimate->PreserveTopologyOn();
        proDecimate->Update();
        
        vtkPolyData *SavedData = vtkPolyData::New();
        SavedData->DeepCopy(label2PolyData->GetOutput());
        
        vtkFloatArray *FA = vtkFloatArray::New();
        int numPoint=SavedData->GetNumberOfPoints();
        FA->SetNumberOfValues(numPoint);
        for (float j=0;j<numPoint;j++ ) FA->SetValue(j,i);
        SavedData->GetPointData()->SetScalars(FA);


        // Generate normals
        vtkPolyDataNormals *PDN = vtkPolyDataNormals::New();     
        PDN->SetInput(SavedData);
        PDN->SetFeatureAngle(90);
        PDN->SplittingOff();
        PDN->Update();


        tot_isosurface->AddInput (PDN->GetOutput());
        
        
        tot_isosurface->Update();
        label2PolyData->Delete();
        
    }
    



    printf(" Write %s \n",outputPolyData);

    //write polydata
    vtkPolyDataWriter * polyDataWriter = vtkPolyDataWriter::New();
    polyDataWriter->SetInput(tot_isosurface->GetOutput());
    polyDataWriter->SetFileName("temp.vtk");
    polyDataWriter->Update();
    
    

    
    printf(" Load IDS file %s \n",idfiles);
    char *buffer = (char *)malloc(4096);
    FILE *fp = fopen(idfiles,"r");
    fgets(buffer,4096,fp);
    map< long , long> Correspondance;;
    while(!feof(fp)){
        std::vector<string> TabSpliter=split(buffer,";");
        Correspondance[atol(TabSpliter[1].c_str())]=atol(TabSpliter[0].c_str());
        fgets(buffer,4096,fp);
        TabSpliter.clear();
    }
    fclose(fp);
    
    
    //We reopen the VTK and change the value by the ID in the lineage
    FILE *fpw = fopen(outputPolyData,"w");
    FILE *fpr = fopen("temp.vtk","r");
    fgets(buffer,4096,fpr);
    bool idss=false;
    while(!feof(fpr)){
        if(strstr(buffer,"NORMALS")>0 || strstr(buffer,"POINT_DATA")>0)  idss=false;
        if(!idss) fprintf(fpw,"%s",buffer);
        else{ //After table we have to change all the ids
            std::vector<string> TabSpliter=split(buffer," ");
            for(int i=0;i<TabSpliter.size()-1;i++){
                if(TabSpliter[i].c_str()!="")
                fprintf(fpw,"%d ",Correspondance[atol(TabSpliter[i].c_str())]);
            }
            fprintf(fpw,"\n");
             TabSpliter.clear();
            
        }
        if(strstr(buffer,"LOOKUP_TABLE")>0) idss=true;
        fgets(buffer,4096,fpr);
       
    }
   //fprintf(fpw,"\n");
    fclose(fpr);
    fclose(fpw);

    
    
    return 0;
}

vector<string> split(string str,string delims)
{
    // Skip delims at beginning, find start of first token
    string::size_type lastPos = str.find_first_not_of(delims, 0);
    // Find next delimiter @ end of token
    string::size_type pos     = str.find_first_of(delims, lastPos);
    
    // output vector
    vector<string> tokens;
    
    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delims.  Note the "not_of". this is beginning of token
        lastPos = str.find_first_not_of(delims, pos);
        // Find next delimiter at end of token.
        pos     = str.find_first_of(delims, lastPos);
    }
    
    return tokens;
}
