#!/bin/bash
# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION="$(O="$(cd "$(dirname "$0")" && pwd)/$(basename "$0")"; while [ ! -e "$O/.bioemergences" -a "$O" != "/" ]; do O="$(dirname "$O")"; done; echo "$O")"
BIWF_ALGOSDIR="${PATHDESTINATION}/Algorithmes"
MOVIT="${PATHDESTINATION}/"


if [ -d $1 ]; then
  inputDir=$1
else
  echo "$1 is not a directory"
  exit
fi

echo "Input VTK Directory : $inputDir"

if [ -n $1 ]; then
  inputSegmentationDir=$2
  if [ "$inputSegmentationDir" == "" ]; then 
    echo "You must specify an segmentation polydata path"
     exit
  fi
else
 echo "You must specify an segmentation polydata path"
  exit
fi

if [ -n $2 ]; then
  outputDir=$3
  if [ "$outputDir" == "" ]; then 
    echo "You must specify an output path"
     exit
  fi
else
  echo "You must specify an output path"
  exit
fi
echo "outputDir : $outputDir"
. ${BIWF_ALGOSDIR}/HelperFunctions.sh


FilePattern=$(getFilePattern $inputDir "vtk")
echo "FilePattern=$FilePattern"

StartTimeStep=$(getStartTime $FilePattern)
echo "StartTimeStep=$StartTimeStep"

EndTimeStep=$(getEndTime $FilePattern $StartTimeStep)
echo "EndTimeStep=$EndTimeStep"
let EndTimeStep=EndTimeStep+1


Trunk=$(basename $FilePattern)
Trunk=${Trunk%%_*}

#the output file path (with file name
LineageOutput=$outputDir/${Trunk}.emb 
echo "Lineage $LineageOutput"



#Jsut to get the Dimension and Spacing
FirstFile=`ls ${inputDir}/*.vtk | head -1`
dimData=$(grep DIMENSIONS $FirstFile)
echo "$dimData"
spacing=$(grep SPACING $FirstFile)
echo "$spacing"
n1=$(echo $dimData|awk '{print $2}')
n2=$(echo $dimData|awk '{print $3}')
n3=$(echo $dimData|awk '{print $4}')
sx=$(echo $spacing|awk '{print $2}')
sy=$(echo $spacing|awk '{print $3}')
sz=$(echo $spacing|awk '{print $4}')

EMBOutput=$(basename $LineageOutput)
EMBOutput=${EMBOutput%.*}_Local
movitpath="${MOVIT}/cache/${EMBOutput}"
mkdir -p ${movitpath}
parametermovit=${movitpath}/parameters.txt

#Define Parameters for Mov-IT
echo "${EMBOutput}:Name">${parametermovit}
echo "Personnal:Comments">>${parametermovit}
echo "${EndTimeStep}:Timesteps">>${parametermovit}
echo "${n1}:X pixels">>${parametermovit}
echo "${n3}:Z pixel">>${parametermovit}
echo "${sx}:X,Y pixel size">>${parametermovit}
echo "${sz}:Z pixel size">>${parametermovit}
echo "1:Delta T">>${parametermovit}
echo "Internal stuff">>${parametermovit}
echo "non">>${parametermovit}
echo "oui:is local">>${parametermovit}
echo "null:srbpath">>${parametermovit}
echo "${n1}:Y pixels">>${parametermovit}
echo "0:HPF">>${parametermovit}
echo "null:Raw URL">>${parametermovit}
echo "null:Emb URL">>${parametermovit}
echo "null:Details URL">>${parametermovit}

#Write PATH data for Mov-IT
rawPath=${movitpath}/rawPaths.txt
trunkEMB=$(getTrunkEMB $inputDir "vtk")
EndtrunkEMB=$(getEndTrunkEMB $inputDir "vtk" $trunkEMB)
echo "${inputDir};${trunkEMB}t;${EndtrunkEMB};${trunkEMB}${EndtrunkEMB}">$rawPath
echo "true;false;false;false;">>$rawPath
echo "${inputDir};${trunkEMB}t;${EndtrunkEMB};${trunkEMB}${EndtrunkEMB}">>$rawPath
echo "true;false;false;false;">>$rawPath
for i in `seq 1 12`; do
  echo ";;;;">>$rawPath
  echo "false;false;false;false;">>$rawPath
done
for i in `seq 1 4`; do
  echo "${inputSegmentationDir};${trunkEMB}t;${EndtrunkEMB};${trunkEMB}${EndtrunkEMB}">>$rawPath
   echo "true;false;false;false;">>$rawPath
done


#Export Lineage for Mov-IT
emblineage=${movitpath}/${EMBOutput}n0t1.emb

cp ${LineageOutput} ${emblineage}

